/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.builders.extensions.types.TypeExtensionHelper;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class Jsr303Extension
extends TypeExtensionHelper {
    @Override
    public void onFieldImplementation(CurrentBuild currentBuild, FieldSpec.Builder typeSpec, TypeDeclaration typeDeclaration) {
        this.addFacetsForAll(typeSpec, typeDeclaration);
        if (typeDeclaration instanceof NumberTypeDeclaration) {
            this.addFacetsForNumbers(typeSpec, (NumberTypeDeclaration)typeDeclaration);
            return;
        }
        if (typeDeclaration instanceof StringTypeDeclaration) {
            this.addFacetsForString(typeSpec, (StringTypeDeclaration)typeDeclaration);
        }
        if (typeDeclaration instanceof ArrayTypeDeclaration) {
            this.addFacetsForArray(typeSpec, (ArrayTypeDeclaration)typeDeclaration);
        }
    }

    private void addFacetsForAll(FieldSpec.Builder typeSpec, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.required() != null && typeDeclaration.required().booleanValue()) {
            typeSpec.addAnnotation(AnnotationSpec.builder(NotNull.class).build());
        }
    }

    private void addFacetsForArray(FieldSpec.Builder typeSpec, ArrayTypeDeclaration typeDeclaration) {
        AnnotationSpec.Builder minMax = null;
        if (typeDeclaration.minItems() != null) {
            minMax = AnnotationSpec.builder(Size.class).addMember("min", "$L", new Object[]{typeDeclaration.minItems()});
        }
        if (typeDeclaration.maxItems() != null) {
            if (minMax == null) {
                minMax = AnnotationSpec.builder(Size.class).addMember("max", "$L", new Object[]{typeDeclaration.maxItems()});
            } else {
                minMax.addMember("max", "$L", new Object[]{typeDeclaration.maxItems()});
            }
        }
        if (minMax != null) {
            typeSpec.addAnnotation(minMax.build());
        }
    }

    private void addFacetsForString(FieldSpec.Builder typeSpec, StringTypeDeclaration typeDeclaration) {
        AnnotationSpec.Builder minMax = null;
        if (typeDeclaration.minLength() != null) {
            minMax = AnnotationSpec.builder(Size.class).addMember("min", "$L", new Object[]{typeDeclaration.minLength()});
        }
        if (typeDeclaration.maxLength() != null) {
            if (minMax == null) {
                minMax = AnnotationSpec.builder(Size.class).addMember("max", "$L", new Object[]{typeDeclaration.maxLength()});
            } else {
                minMax.addMember("max", "$L", new Object[]{typeDeclaration.maxLength()});
            }
        }
        if (minMax != null) {
            typeSpec.addAnnotation(minMax.build());
        }
    }

    private void addFacetsForNumbers(FieldSpec.Builder typeSpec, NumberTypeDeclaration typeDeclaration) {
        FieldSpec t = typeSpec.build();
        if (typeDeclaration.minimum() != null && this.isInteger(t.type)) {
            typeSpec.addAnnotation(AnnotationSpec.builder(Min.class).addMember("value", "$L", new Object[]{typeDeclaration.minimum().intValue()}).build());
        }
        if (typeDeclaration.maximum() != null && this.isInteger(t.type)) {
            typeSpec.addAnnotation(AnnotationSpec.builder(Max.class).addMember("value", "$L", new Object[]{typeDeclaration.maximum().intValue()}).build());
        }
    }

    private boolean isInteger(TypeName type) {
        return type.box().toString().equals(Integer.class.getName()) || type.box().toString().equals(Short.class.getName()) || type.box().toString().equals(Byte.class.getName()) || type.box().toString().equals(BigDecimal.class.getName()) || type.box().toString().equals(Long.class.getName()) || type.box().toString().equals(BigInteger.class.getName());
    }
}

