/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import joptsimple.internal.Strings;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class UnionDeserializationGenerator
implements JavaPoetTypeGenerator {
    private final CurrentBuild currentBuild;
    private final V10GType unionTypeDeclaration;
    private final ClassName name;

    public UnionDeserializationGenerator(CurrentBuild currentBuild, V10GType unionTypeDeclaration, ClassName name) {
        this.currentBuild = currentBuild;
        this.unionTypeDeclaration = unionTypeDeclaration;
        this.name = name;
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
        UnionTypeDeclaration union = (UnionTypeDeclaration)this.unionTypeDeclaration.implementation();
        ClassName unionTypeName = ClassName.get((String)this.currentBuild.getModelPackage(), (String)Annotations.CLASS_NAME.get(Names.typeName(union.name()), this.unionTypeDeclaration), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.name).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdDeserializer.class), (TypeName[])new TypeName[]{unionTypeName})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super($T.class);", new Object[]{unionTypeName}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder deserialize = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonParser.class), (String)"jsonParser", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(DeserializationContext.class), (String)"jsonContext", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class).returns((TypeName)unionTypeName).addStatement("$T mapper  = new $T()", new Object[]{ObjectMapper.class, ObjectMapper.class}).addStatement("$T<String, Object> map = mapper.readValue(jsonParser, Map.class)", new Object[]{Map.class});
        for (TypeDeclaration typeDeclaration : union.of()) {
            ClassName unionPossibility = ClassName.get((String)this.currentBuild.getModelPackage(), (String)Names.typeName(typeDeclaration.name()), (String[])new String[0]);
            String fieldName = typeDeclaration.name();
            deserialize.addStatement("if ( looksLike" + fieldName + "(map) ) return new $T(mapper.convertValue(map, $T.class))", new Object[]{unionTypeName, unionPossibility});
            this.buildLooksLike(builder, typeDeclaration);
        }
        deserialize.addStatement("throw new $T($S + map)", new Object[]{IOException.class, "Can't figure out type of object"});
        builder.addMethod(deserialize.build());
        rootDirectory.into(builder);
    }

    private void buildLooksLike(TypeSpec.Builder builder, TypeDeclaration typeDeclaration) {
        String name = Names.methodName("looksLike", typeDeclaration.name());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)name).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)}), "map", new Modifier[0]);
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            ObjectTypeDeclaration otd = (ObjectTypeDeclaration)typeDeclaration;
            List names = Lists.transform((List)otd.properties(), (Function)new Function<TypeDeclaration, String>(){

                @Nullable
                public String apply(@Nullable TypeDeclaration input) {
                    return "\"" + input.name() + "\"";
                }
            });
            spec.addStatement("return map.keySet().containsAll($T.asList($L))", new Object[]{Arrays.class, Strings.join((List)names, (String)",")});
        }
        spec.addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.BOOLEAN);
        builder.addMethod(spec.build());
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory, BuildPhase buildPhase) throws IOException {
        this.output(rootDirectory);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.name;
    }
}

