/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.ScalarTypes;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.types.V10GTypeFactory;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class V10TypeRegistry {
    private Map<String, V10GType> types = new HashMap<String, V10GType>();
    private Multimap<String, V10GType> childMap = ArrayListMultimap.create();

    public void addChildToParent(List<V10GType> parents, V10GType child) {
        for (V10GType parent : parents) {
            if (parent.name().equals("object")) continue;
            this.childMap.put((Object)parent.name(), (Object)child);
            this.addChildToParent(parent.parentTypes(), child);
        }
    }

    public V10GType fetchType(Resource resource, Method method, TypeDeclaration typeDeclaration) {
        String key = Names.ramlTypeName(resource, method, typeDeclaration);
        if (this.types.containsKey(key)) {
            return this.types.get(key);
        }
        V10GType type = V10GTypeFactory.createRequestBodyType(this, resource, method, typeDeclaration);
        this.types.put(type.name(), type);
        return type;
    }

    public V10GType fetchType(Resource resource, Method method, Response response, TypeDeclaration typeDeclaration) {
        String key = Names.ramlTypeName(resource, method, response, typeDeclaration);
        if (this.types.containsKey(key)) {
            return this.types.get(key);
        }
        V10GType type = V10GTypeFactory.createResponseBodyType(this, resource, method, response, typeDeclaration);
        this.types.put(type.name(), type);
        return type;
    }

    public V10GType fetchType(String name, TypeDeclaration typeDeclaration) {
        Class<?> javaType = ScalarTypes.scalarToJavaType(typeDeclaration);
        if (javaType != null) {
            if (typeDeclaration instanceof StringTypeDeclaration && ((StringTypeDeclaration)typeDeclaration).enumValues().size() > 0) {
                V10GType type = V10GTypeFactory.createEnum(this, name, (StringTypeDeclaration)typeDeclaration);
                this.types.put(type.name(), type);
                return type;
            }
            return V10GTypeFactory.createScalar(name, typeDeclaration);
        }
        if (typeDeclaration instanceof ArrayTypeDeclaration) {
            return V10GTypeFactory.createArray(this, name, (ArrayTypeDeclaration)typeDeclaration);
        }
        if (this.types.containsKey(name)) {
            return this.types.get(name);
        }
        V10GType type = typeDeclaration instanceof JSONTypeDeclaration ? V10GTypeFactory.createJson((JSONTypeDeclaration)typeDeclaration, typeDeclaration.name()) : (typeDeclaration instanceof XMLTypeDeclaration ? V10GTypeFactory.createXml((XMLTypeDeclaration)typeDeclaration, typeDeclaration.name()) : (typeDeclaration instanceof UnionTypeDeclaration ? V10GTypeFactory.createUnion(this, (UnionTypeDeclaration)typeDeclaration, typeDeclaration.name()) : V10GTypeFactory.createExplicitlyNamedType(this, name, typeDeclaration)));
        this.types.put(type.name(), type);
        return type;
    }

    public V10GType fetchType(TypeDeclaration typeDeclaration) {
        String name = typeDeclaration.name();
        return this.fetchType(name, typeDeclaration);
    }

    public V10GType createInlineType(String name, String javaTypeName, TypeDeclaration typeDeclaration) {
        Class<?> javaType = ScalarTypes.scalarToJavaType(typeDeclaration);
        if (javaType != null) {
            if (typeDeclaration instanceof StringTypeDeclaration && ((StringTypeDeclaration)typeDeclaration).enumValues().size() > 0) {
                V10GType type = V10GTypeFactory.createEnum(this, name, javaTypeName, (StringTypeDeclaration)typeDeclaration);
                this.types.put(type.name(), type);
                return type;
            }
            return V10GTypeFactory.createScalar(name, typeDeclaration);
        }
        if (typeDeclaration instanceof ArrayTypeDeclaration) {
            return V10GTypeFactory.createArray(this, name, (ArrayTypeDeclaration)typeDeclaration);
        }
        if (this.types.containsKey(name)) {
            return this.types.get(name);
        }
        V10GType type = typeDeclaration instanceof JSONTypeDeclaration ? V10GTypeFactory.createJson((JSONTypeDeclaration)typeDeclaration, typeDeclaration.name(), javaTypeName) : (typeDeclaration instanceof XMLTypeDeclaration ? V10GTypeFactory.createXml((XMLTypeDeclaration)typeDeclaration, typeDeclaration.name(), javaTypeName) : (typeDeclaration instanceof UnionTypeDeclaration ? V10GTypeFactory.createUnion(this, (UnionTypeDeclaration)typeDeclaration, typeDeclaration.name(), javaTypeName) : V10GTypeFactory.createInlineType(this, name, javaTypeName, typeDeclaration)));
        this.types.put(type.name(), type);
        return type;
    }

    public Multimap<String, V10GType> getChildClasses() {
        return this.childMap;
    }

    public V10TypeRegistry createRegistry() {
        V10TypeRegistry registry = new V10TypeRegistry();
        registry.types = new HashMap<String, V10GType>();
        registry.types.putAll(this.types);
        registry.childMap = this.childMap;
        return registry;
    }
}

