/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.typegenerators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.GeneratorType;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.SchemaTypeFactory;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.extension.types.MethodExtension;
import org.raml.jaxrs.generator.extension.types.MethodType;
import org.raml.jaxrs.generator.extension.types.PredefinedFieldType;
import org.raml.jaxrs.generator.extension.types.PredefinedMethodType;
import org.raml.jaxrs.generator.extension.types.TypeContext;
import org.raml.jaxrs.generator.extension.types.TypeExtension;
import org.raml.jaxrs.generator.ramltypes.GProperty;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.PropertyInfo;
import org.raml.jaxrs.generator.v10.V10GProperty;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.jaxrs.generator.v10.types.V10TypeFactory;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class SimpleInheritanceExtension
implements TypeExtension {
    private final V10GType originalType;
    private final V10TypeRegistry registry;
    private final CurrentBuild currentBuild;

    public SimpleInheritanceExtension(V10GType originalType, V10TypeRegistry registry, CurrentBuild currentBuild) {
        this.originalType = originalType;
        this.registry = registry;
        this.currentBuild = currentBuild;
    }

    @Override
    public TypeSpec.Builder onType(TypeContext context, TypeSpec.Builder builder, V10GType objectType, BuildPhase buildPhase) {
        if (buildPhase == BuildPhase.INTERFACE) {
            return this.buildDeclaration(context, objectType);
        }
        return this.buildTypeImplementation(context, objectType);
    }

    private TypeSpec.Builder buildTypeImplementation(TypeContext context, V10GType objectType) {
        ClassName className = this.originalType.javaImplementationName(context.getModelPackage());
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ClassName parentClassName = (ClassName)this.originalType.defaultJavaTypeName(context.getModelPackage());
        if (parentClassName != null) {
            typeSpec.addSuperinterface((TypeName)parentClassName);
        }
        if ((typeSpec = this.runClassExtensions(context, objectType, typeSpec, BuildPhase.IMPLEMENTATION, Annotations.ON_TYPE_CLASS_CREATION)) == null) {
            return null;
        }
        V10TypeRegistry localRegistry = this.registry.createRegistry();
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        int internalTypeCounter = 0;
        for (GProperty gProperty : this.originalType.properties()) {
            if (gProperty.isInline()) {
                String internalTypeName = Integer.toString(internalTypeCounter);
                V10GType type = localRegistry.createInlineType(internalTypeName, Annotations.CLASS_NAME.get(Names.typeName(gProperty.name(), "Type"), (Annotable)gProperty.implementation(), new Annotable[0]), (TypeDeclaration)gProperty.implementation());
                TypeGenerator internalGenerator = SimpleInheritanceExtension.inlineTypeBuild(localRegistry, this.currentBuild, GeneratorType.generatorFrom(type));
                if (internalGenerator instanceof JavaPoetTypeGenerator) {
                    properties.add(new PropertyInfo(localRegistry, gProperty.overrideType(type)));
                    ++internalTypeCounter;
                    continue;
                }
                throw new GenerationException("internal type bad");
            }
            properties.add(new PropertyInfo(localRegistry, gProperty));
        }
        this.buildPropertiesForImplementation(context, objectType, typeSpec, properties);
        typeSpec = this.runClassExtensions(context, objectType, typeSpec, BuildPhase.IMPLEMENTATION, Annotations.ON_TYPE_CLASS_FINISH);
        return typeSpec;
    }

    private void buildPropertiesForImplementation(TypeContext context, V10GType objectType, TypeSpec.Builder typeSpec, List<PropertyInfo> properties) {
        for (PropertyInfo propertyInfo : properties) {
            FieldSpec.Builder fieldSpec = FieldSpec.builder((TypeName)propertyInfo.resolve(context), (String)Names.variableName(propertyInfo.getName()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
            if (propertyInfo.getName().equals(objectType.discriminator())) {
                fieldSpec.initializer("$S", new Object[]{objectType.discriminatorValue()});
            }
            fieldSpec = context.onField(context, typeSpec, fieldSpec, objectType, (V10GProperty)propertyInfo.getProperty(), BuildPhase.IMPLEMENTATION, PredefinedFieldType.PROPERTY);
            fieldSpec = this.currentBuild.getFieldExtension(Annotations.ON_TYPE_FIELD_CREATION, objectType).onField(context, typeSpec, fieldSpec, objectType, (V10GProperty)propertyInfo.getProperty(), BuildPhase.IMPLEMENTATION, PredefinedFieldType.PROPERTY);
            if (fieldSpec != null) {
                typeSpec.addField(fieldSpec.build());
            }
            MethodSpec.Builder getSpec = MethodSpec.methodBuilder((String)("get" + Names.typeName(propertyInfo.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this." + Names.variableName(propertyInfo.getName()), new Object[0]);
            getSpec.returns(propertyInfo.resolve(context));
            getSpec = this.runMethodExtensions(context, objectType, typeSpec, getSpec, Collections.emptyList(), (V10GProperty)propertyInfo.getProperty(), BuildPhase.IMPLEMENTATION, PredefinedMethodType.GETTER, Annotations.ON_TYPE_METHOD_CREATION);
            if (getSpec != null) {
                typeSpec.addMethod(getSpec.build());
            }
            if (propertyInfo.getName().equals(objectType.discriminator())) continue;
            MethodSpec.Builder setSpec = MethodSpec.methodBuilder((String)("set" + Names.typeName(propertyInfo.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this." + Names.variableName(propertyInfo.getName()) + " = " + Names.variableName(propertyInfo.getName()), new Object[0]);
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)propertyInfo.resolve(context), (String)Names.variableName(propertyInfo.getName()), (Modifier[])new Modifier[0]);
            setSpec.addParameter(parameterSpec.build());
            if ((setSpec = this.runMethodExtensions(context, objectType, typeSpec, setSpec, Collections.singletonList(parameterSpec), (V10GProperty)propertyInfo.getProperty(), BuildPhase.IMPLEMENTATION, PredefinedMethodType.SETTER, Annotations.ON_TYPE_METHOD_CREATION)) == null) continue;
            typeSpec.addMethod(setSpec.build());
        }
    }

    private TypeSpec.Builder buildDeclaration(TypeContext context, V10GType objectType) {
        List<V10GType> parentTypes = this.originalType.parentTypes();
        int internalTypeCounter = 0;
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        V10TypeRegistry localRegistry = this.registry.createRegistry();
        for (GProperty gProperty : this.originalType.properties()) {
            if (gProperty.isInline()) {
                String internalTypeName = Integer.toString(internalTypeCounter);
                V10GType v10GType = localRegistry.createInlineType(internalTypeName, Annotations.CLASS_NAME.get(Names.typeName(gProperty.name(), "Type"), (Annotable)gProperty.implementation(), new Annotable[0]), (TypeDeclaration)gProperty.implementation());
                TypeGenerator internalGenerator = SimpleInheritanceExtension.inlineTypeBuild(localRegistry, this.currentBuild, GeneratorType.generatorFrom(v10GType));
                if (internalGenerator instanceof JavaPoetTypeGenerator) {
                    properties.add(new PropertyInfo(localRegistry, gProperty.overrideType(v10GType)));
                    context.createInternalClass((JavaPoetTypeGenerator)internalGenerator);
                    ++internalTypeCounter;
                    continue;
                }
                throw new GenerationException("internal type bad");
            }
            properties.add(new PropertyInfo(localRegistry, gProperty));
        }
        ClassName interf = (ClassName)this.originalType.defaultJavaTypeName(context.getModelPackage());
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)interf).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (GType gType : parentTypes) {
            if ("object".equals(gType.name())) continue;
            builder.addSuperinterface(gType.defaultJavaTypeName(context.getModelPackage()));
        }
        TypeSpec.Builder builder2 = this.runClassExtensions(context, objectType, builder, BuildPhase.INTERFACE, Annotations.ON_TYPE_CLASS_CREATION);
        if (builder2 == null) {
            return null;
        }
        this.buildPropertiesForInterface(context, objectType, properties, builder2);
        context.addImplementation();
        TypeSpec.Builder builder3 = this.runClassExtensions(context, objectType, builder2, BuildPhase.INTERFACE, Annotations.ON_TYPE_CLASS_FINISH);
        return builder3;
    }

    private void buildPropertiesForInterface(TypeContext context, V10GType objectType, List<PropertyInfo> properties, TypeSpec.Builder typeSpec) {
        for (PropertyInfo propertyInfo : properties) {
            MethodSpec.Builder getSpec = MethodSpec.methodBuilder((String)Names.methodName("get", propertyInfo.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            getSpec.returns(propertyInfo.resolve(context));
            getSpec = this.runMethodExtensions(context, objectType, typeSpec, getSpec, Collections.emptyList(), (V10GProperty)propertyInfo.getProperty(), BuildPhase.INTERFACE, PredefinedMethodType.GETTER, Annotations.ON_TYPE_METHOD_CREATION);
            if (getSpec != null) {
                typeSpec.addMethod(getSpec.build());
            }
            if (propertyInfo.getName().equals(objectType.discriminator())) continue;
            MethodSpec.Builder setSpec = MethodSpec.methodBuilder((String)Names.methodName("set", propertyInfo.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)propertyInfo.resolve(context), (String)Names.variableName(propertyInfo.getName()), (Modifier[])new Modifier[0]);
            setSpec.addParameter(parameterSpec.build());
            if ((setSpec = this.runMethodExtensions(context, objectType, typeSpec, setSpec, Collections.singletonList(parameterSpec), (V10GProperty)propertyInfo.getProperty(), BuildPhase.INTERFACE, PredefinedMethodType.SETTER, Annotations.ON_TYPE_METHOD_CREATION)) == null) continue;
            typeSpec.addMethod(setSpec.build());
        }
    }

    private static TypeGenerator inlineTypeBuild(V10TypeRegistry registry, CurrentBuild currentBuild, GeneratorType type) {
        switch (type.getObjectType()) {
            case ENUMERATION_TYPE: {
                return V10TypeFactory.createEnumerationType(currentBuild, type.getDeclaredType());
            }
            case PLAIN_OBJECT_TYPE: {
                return V10TypeFactory.createObjectType(registry, currentBuild, (V10GType)type.getDeclaredType(), false);
            }
            case JSON_OBJECT_TYPE: {
                return SchemaTypeFactory.createJsonType(currentBuild, type.getDeclaredType());
            }
            case XML_OBJECT_TYPE: {
                return SchemaTypeFactory.createXmlType(currentBuild, type.getDeclaredType());
            }
        }
        throw new GenerationException("don't know what to do with type " + type.getDeclaredType());
    }

    private MethodSpec.Builder runMethodExtensions(TypeContext context, V10GType objectType, TypeSpec.Builder typeSpec, MethodSpec.Builder getSpec, List<ParameterSpec.Builder> parameters, V10GProperty property, BuildPhase phase, MethodType methodType, Annotations<MethodExtension> annotations) {
        MethodSpec.Builder builder = context.onMethod(context, typeSpec, getSpec, parameters, objectType, property, phase, methodType);
        builder = this.currentBuild.getMethodExtension(annotations, objectType).onMethod(context, typeSpec, builder, parameters, objectType, property, phase, methodType);
        return builder;
    }

    private TypeSpec.Builder runClassExtensions(TypeContext context, V10GType objectType, TypeSpec.Builder typeSpec, BuildPhase buildPhase, Annotations<TypeExtension> annotation) {
        if (annotation == Annotations.ON_TYPE_CLASS_CREATION) {
            typeSpec = context.onType(context, typeSpec, objectType, buildPhase);
        }
        typeSpec = this.currentBuild.getTypeExtension(annotation, objectType).onType(context, typeSpec, objectType, buildPhase);
        return typeSpec;
    }
}

