/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.types;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import org.raml.jaxrs.generator.ScalarTypes;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.types.V10GTypeHelper;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class V10GTypeScalar
extends V10GTypeHelper {
    private final TypeDeclaration scalar;
    private final String ramlName;

    public V10GTypeScalar(String name, TypeDeclaration scalar) {
        super(name);
        this.scalar = scalar;
        this.ramlName = name;
    }

    @Override
    public TypeDeclaration implementation() {
        return this.scalar;
    }

    @Override
    public String type() {
        return this.ramlName;
    }

    @Override
    public String name() {
        return this.ramlName;
    }

    @Override
    public TypeName defaultJavaTypeName(String pack) {
        String annotation = Annotations.CLASS_NAME.get((String)null, (Annotable)this.scalar, new Annotable[0]);
        if (annotation == null) {
            return ScalarTypes.classToTypeName(ScalarTypes.scalarToJavaType(this.scalar));
        }
        if (annotation.contains(".")) {
            return ClassName.bestGuess((String)annotation);
        }
        return ClassName.get((String)pack, (String)annotation, (String[])new String[0]);
    }

    @Override
    public ClassName javaImplementationName(String pack) {
        return ClassName.get(ScalarTypes.scalarToJavaType(this.scalar));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof V10GType)) {
            return false;
        }
        V10GType v10GType = (V10GType)o;
        return this.ramlName.equals(v10GType.name());
    }

    @Override
    public int hashCode() {
        return this.ramlName.hashCode();
    }
}

