/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Set;
import org.raml.jaxrs.model.JaxRsApplication;
import org.raml.jaxrs.parser.JaxRsParser;
import org.raml.jaxrs.parser.JaxRsParsingException;
import org.raml.jaxrs.parser.analyzers.Analyzers;
import org.raml.jaxrs.parser.gatherers.JerseyGatherer;
import org.raml.jaxrs.parser.source.SourceParser;
import org.raml.jaxrs.parser.util.ClassLoaderUtils;
import org.raml.utilities.format.Joiners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JerseyJaxRsParser
implements JaxRsParser {
    private static final Logger logger = LoggerFactory.getLogger(JerseyJaxRsParser.class);
    private final Path jaxRsResource;
    private final SourceParser sourceParser;

    private JerseyJaxRsParser(Path jaxRsResource, SourceParser sourceParser) {
        this.jaxRsResource = jaxRsResource;
        this.sourceParser = sourceParser;
    }

    public static JerseyJaxRsParser create(Path classesPath, SourceParser sourceParser) {
        Preconditions.checkNotNull((Object)classesPath);
        Preconditions.checkNotNull((Object)sourceParser);
        return new JerseyJaxRsParser(classesPath, sourceParser);
    }

    @Override
    public JaxRsApplication parse() throws JaxRsParsingException {
        logger.info("parsing JaxRs resource: {}", (Object)this.jaxRsResource);
        Iterable<Class<?>> classes = JerseyJaxRsParser.getJaxRsClassesFor(this.jaxRsResource);
        return Analyzers.jerseyAnalyzerFor(classes, this.sourceParser).analyze();
    }

    private static Iterable<Class<?>> getJaxRsClassesFor(Path jaxRsResource) throws JaxRsParsingException {
        ClassLoader classLoader;
        try {
            classLoader = ClassLoaderUtils.classLoaderFor(jaxRsResource);
        }
        catch (MalformedURLException e) {
            throw new JaxRsParsingException(String.format("unable to create classloader from %s", jaxRsResource), e);
        }
        Set<Class<?>> classes = JerseyGatherer.builder().forApplications(jaxRsResource, new Path[0]).withClassLoader(classLoader).build().jaxRsClasses();
        if (logger.isDebugEnabled()) {
            logger.debug("found JaxRs related classes: \n{}", (Object)Joiners.squareBracketsPerLineJoiner().join(classes));
        }
        return classes;
    }
}

