/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.analyzers;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.raml.jaxrs.model.JaxRsApplication;
import org.raml.jaxrs.parser.analyzers.Analyzer;
import org.raml.jaxrs.parser.analyzers.JerseyBridge;
import org.raml.jaxrs.parser.model.JerseyJaxRsApplication;
import org.raml.jaxrs.parser.source.SourceParser;
import org.raml.utilities.format.Joiners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JerseyAnalyzer
implements Analyzer {
    private static final Logger logger = LoggerFactory.getLogger(JerseyAnalyzer.class);
    private final ImmutableSet<Class<?>> jaxRsClasses;
    private final JerseyBridge jerseyBridge;
    private final SourceParser sourceParser;

    private JerseyAnalyzer(ImmutableSet<Class<?>> jaxRsClasses, JerseyBridge jerseyBridge, SourceParser sourceParser) {
        this.jaxRsClasses = jaxRsClasses;
        this.jerseyBridge = jerseyBridge;
        this.sourceParser = sourceParser;
    }

    static JerseyAnalyzer create(Iterable<Class<?>> classes, JerseyBridge jerseyBridge, SourceParser sourceParser) {
        Preconditions.checkNotNull(classes);
        Preconditions.checkNotNull((Object)jerseyBridge);
        Preconditions.checkNotNull((Object)sourceParser);
        return new JerseyAnalyzer(ImmutableSet.copyOf(classes), jerseyBridge, sourceParser);
    }

    @Override
    public JaxRsApplication analyze() {
        logger.debug("analyzing...");
        FluentIterable<Resource> jerseyResources = this.jerseyBridge.resourcesFrom((Iterable<Class<?>>)this.jaxRsClasses);
        if (logger.isDebugEnabled()) {
            logger.debug("found jersey resources: \n{}", (Object)Joiners.squareBracketsPerLineJoiner().join(jerseyResources));
        }
        List<RuntimeResource> runtimeResources = this.jerseyBridge.runtimeResourcesFrom(jerseyResources);
        if (logger.isDebugEnabled()) {
            logger.debug("found runtime resources: \n{}", (Object)Joiners.squareBracketsPerLineJoiner().join(runtimeResources));
        }
        return JerseyJaxRsApplication.fromRuntimeResources(runtimeResources, this.sourceParser);
    }
}

