/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.raml.jaxrs.model.HttpVerb;
import org.raml.jaxrs.model.JaxRsHeaderParameter;
import org.raml.jaxrs.model.JaxRsMethod;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.parser.model.Utilities;
import org.raml.jaxrs.parser.source.SourceParser;

class JerseyJaxRsMethod
implements JaxRsMethod {
    private final ResourceMethod resourceMethod;
    private final SourceParser sourceParser;

    private JerseyJaxRsMethod(ResourceMethod resourceMethod, SourceParser sourceParser) {
        this.resourceMethod = resourceMethod;
        this.sourceParser = sourceParser;
    }

    public static JerseyJaxRsMethod create(ResourceMethod resourceMethod, SourceParser sourceParser) {
        Preconditions.checkNotNull((Object)resourceMethod);
        Preconditions.checkNotNull((Object)sourceParser);
        return new JerseyJaxRsMethod(resourceMethod, sourceParser);
    }

    public HttpVerb getHttpVerb() {
        return HttpVerb.fromStringUnchecked((String)this.resourceMethod.getHttpMethod());
    }

    public List<MediaType> getConsumedMediaTypes() {
        return this.resourceMethod.getConsumedTypes();
    }

    public List<MediaType> getProducedMediaTypes() {
        return this.resourceMethod.getProducedTypes();
    }

    public List<JaxRsQueryParameter> getQueryParameters() {
        return Utilities.toJaxRsQueryParameters(Utilities.getQueryParameters(this.resourceMethod)).toList();
    }

    public List<JaxRsHeaderParameter> getHeaderParameters() {
        return Utilities.toJaxRsHeaderParameters(Utilities.getHeaderParameters(this.resourceMethod)).toList();
    }

    public Optional<String> getDescription() {
        return this.sourceParser.getDocumentationFor(this.resourceMethod.getInvocable().getDefinitionMethod());
    }
}

