/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import javax.annotation.Nullable;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.raml.jaxrs.model.JaxRsHeaderParameter;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsHeaderParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsQueryParameter;

class Utilities {
    private static final Predicate<Parameter> IS_QUERY_PARAMETER_PREDICATE = new Predicate<Parameter>(){

        public boolean apply(@Nullable Parameter parameter) {
            return parameter.getSource() == Parameter.Source.QUERY;
        }
    };
    public static final Predicate<Parameter> IS_HEADER_PARAMETER_PREDICATE = new Predicate<Parameter>(){

        public boolean apply(@Nullable Parameter parameter) {
            return parameter.getSource() == Parameter.Source.HEADER;
        }
    };

    private Utilities() {
    }

    public static FluentIterable<Parameter> getQueryParameters(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter(Utilities.isQueryParameterPredicate());
    }

    public static FluentIterable<JaxRsQueryParameter> toJaxRsQueryParameters(Iterable<Parameter> parameters) {
        return FluentIterable.from(parameters).transform((Function)new Function<Parameter, JaxRsQueryParameter>(){

            @Nullable
            public JaxRsQueryParameter apply(@Nullable Parameter parameter) {
                return JerseyJaxRsQueryParameter.create(parameter);
            }
        });
    }

    public static Predicate<Parameter> isQueryParameterPredicate() {
        return IS_QUERY_PARAMETER_PREDICATE;
    }

    public static FluentIterable<Parameter> getHeaderParameters(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter(Utilities.isHeaderParameterPredicate());
    }

    public static Predicate<Parameter> isHeaderParameterPredicate() {
        return IS_HEADER_PARAMETER_PREDICATE;
    }

    public static FluentIterable<JaxRsHeaderParameter> toJaxRsHeaderParameters(Iterable<Parameter> headerParameters) {
        return FluentIterable.from(headerParameters).transform((Function)new Function<Parameter, JaxRsHeaderParameter>(){

            @Nullable
            public JaxRsHeaderParameter apply(@Nullable Parameter parameter) {
                return JerseyJaxRsHeaderParameter.create(parameter);
            }
        });
    }
}

