/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.source;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.MethodHolder;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.raml.jaxrs.parser.source.SourceParser;
import org.raml.jaxrs.parser.source.Utilities;
import org.raml.utilities.format.Joiners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoasterSourceParser
implements SourceParser {
    private static final Logger logger = LoggerFactory.getLogger(RoasterSourceParser.class);
    private final Path sourceRoot;

    private RoasterSourceParser(Path sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public static RoasterSourceParser create(Path sourceRoot) {
        Preconditions.checkNotNull((Object)sourceRoot);
        return new RoasterSourceParser(sourceRoot);
    }

    @Override
    public Optional<String> getDocumentationFor(java.lang.reflect.Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Path classFileRelativePath = Utilities.getSourceFileRelativePath(declaringClass);
        Path relativeFromRoot = this.sourceRoot.resolve(classFileRelativePath);
        if (!Files.isRegularFile(relativeFromRoot, new LinkOption[0])) {
            logger.warn("could not find source file {} for method {}", (Object)relativeFromRoot, (Object)method);
            return Optional.absent();
        }
        return this.parseDocumentationFor(method, relativeFromRoot);
    }

    private Optional<String> parseDocumentationFor(java.lang.reflect.Method method, Path file) {
        try {
            JavaType parsed = Roaster.parse((File)file.toFile());
            if (!(parsed instanceof MethodHolder)) {
                logger.warn("unexpected type returned from roaster: {}", parsed.getClass());
                return Optional.absent();
            }
            return RoasterSourceParser.extractMethodJavadoc(method, (MethodHolder)parsed);
        }
        catch (FileNotFoundException e) {
            logger.warn("exception occurred while attempting to parse file {} for method {}", new Object[]{file, method, e});
            return Optional.absent();
        }
    }

    private static Optional<String> extractMethodJavadoc(java.lang.reflect.Method method, MethodHolder<?> parsed) {
        String methodName = method.getName();
        List methods = parsed.getMethods();
        for (Method parsedMethod : methods) {
            if (!parsedMethod.getName().equals(methodName)) continue;
            if (!(parsedMethod instanceof MethodSource)) {
                logger.warn("unexpected method type: {}", parsedMethod.getClass());
                return Optional.absent();
            }
            MethodSource methodSource = (MethodSource)parsedMethod;
            return RoasterSourceParser.javadocToContent(methodSource.getJavaDoc());
        }
        logger.warn("could not find method {} in parsed methods: {}", (Object)method, (Object)Joiners.squareBracketsSameLineJoiner().join((Iterable)methods));
        return Optional.absent();
    }

    private static Optional<String> javadocToContent(JavaDocSource javaDoc) {
        return Optional.fromNullable((Object)javaDoc.getText());
    }
}

