/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.jersey.server.model.Parameter;
import org.raml.jaxrs.model.JaxRsHeaderParameter;
import org.raml.jaxrs.parser.model.Utilities;

class JerseyJaxRsHeaderParameter
implements JaxRsHeaderParameter {
    private final Parameter parameter;

    private JerseyJaxRsHeaderParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    static JerseyJaxRsHeaderParameter create(Parameter parameter) {
        Preconditions.checkNotNull((Object)parameter);
        Preconditions.checkArgument((boolean)Utilities.isHeaderParameterPredicate().apply((Object)parameter), (String)"invalid header parameter %s", (Object[])new Object[]{parameter});
        return new JerseyJaxRsHeaderParameter(parameter);
    }

    public String getName() {
        return this.parameter.getSourceName();
    }

    public Optional<String> getDefaultValue() {
        return Optional.fromNullable((Object)this.parameter.getDefaultValue());
    }

    public Type getType() {
        return this.parameter.getType();
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return Optional.fromNullable((Object)this.parameter.getAnnotation(annotationType));
    }
}

