/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.jersey.server.model.Parameter;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.parser.model.Utilities;

class JerseyJaxRsQueryParameter
implements JaxRsQueryParameter {
    private final Parameter parameter;

    private JerseyJaxRsQueryParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    static JerseyJaxRsQueryParameter create(Parameter parameter) {
        Preconditions.checkNotNull((Object)parameter);
        Preconditions.checkArgument((boolean)Utilities.isQueryParameterPredicate().apply((Object)parameter), (String)"invalid query parameter %s", (Object[])new Object[]{parameter});
        return new JerseyJaxRsQueryParameter(parameter);
    }

    public String getName() {
        return this.parameter.getSourceName();
    }

    public Optional<String> getDefaultValue() {
        return Optional.fromNullable((Object)this.parameter.getDefaultValue());
    }

    public Type getType() {
        return this.parameter.getType();
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return Optional.fromNullable((Object)this.parameter.getAnnotation(annotationType));
    }
}

