/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import javax.annotation.Nullable;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.raml.jaxrs.model.JaxRsEntity;
import org.raml.jaxrs.model.JaxRsFormParameter;
import org.raml.jaxrs.model.JaxRsHeaderParameter;
import org.raml.jaxrs.model.JaxRsMultiPartFormDataParameter;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsEntity;
import org.raml.jaxrs.parser.model.JerseyJaxRsFormParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsHeaderParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsMultiPartFormDataParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsQueryParameter;
import org.raml.jaxrs.parser.source.SourceParser;

class Utilities {
    private static final Predicate<Parameter> IS_QUERY_PARAMETER_PREDICATE = new Predicate<Parameter>(){

        public boolean apply(@Nullable Parameter parameter) {
            return parameter.getSource() == Parameter.Source.QUERY;
        }
    };
    private static final Predicate<Parameter> IS_FORM_PARAMETER_PREDICATE = new Predicate<Parameter>(){

        public boolean apply(@Nullable Parameter parameter) {
            return parameter.getSource() == Parameter.Source.FORM;
        }
    };
    private static final Predicate<Parameter> IS_CONSUMED_PARAMETER_PREDICATE = new Predicate<Parameter>(){

        public boolean apply(@Nullable Parameter parameter) {
            return parameter.getSource() == Parameter.Source.ENTITY;
        }
    };
    public static final Predicate<Parameter> IS_HEADER_PARAMETER_PREDICATE = new Predicate<Parameter>(){

        public boolean apply(@Nullable Parameter parameter) {
            return parameter.getSource() == Parameter.Source.HEADER;
        }
    };

    private Utilities() {
    }

    public static FluentIterable<Parameter> getMultiPartFormDataParameter(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter((Predicate)new Predicate<Parameter>(){

            public boolean apply(@Nullable Parameter input) {
                return input.isAnnotationPresent(FormDataParam.class) && input.getRawType() != FormDataContentDisposition.class;
            }
        });
    }

    public static FluentIterable<Parameter> getQueryParameters(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter(Utilities.isQueryParameterPredicate());
    }

    public static FluentIterable<Parameter> getConsumedParameter(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter(Utilities.isConsumedParameterPredicate());
    }

    public static FluentIterable<Parameter> getFormParameters(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter(Utilities.isFormParameterPredicate());
    }

    public static FluentIterable<JaxRsQueryParameter> toJaxRsQueryParameters(Iterable<Parameter> parameters) {
        return FluentIterable.from(parameters).transform((Function)new Function<Parameter, JaxRsQueryParameter>(){

            @Nullable
            public JaxRsQueryParameter apply(@Nullable Parameter parameter) {
                return JerseyJaxRsQueryParameter.create(parameter);
            }
        });
    }

    public static Predicate<Parameter> isQueryParameterPredicate() {
        return IS_QUERY_PARAMETER_PREDICATE;
    }

    public static Predicate<Parameter> isFormParameterPredicate() {
        return IS_FORM_PARAMETER_PREDICATE;
    }

    public static Predicate<Parameter> isConsumedParameterPredicate() {
        return IS_CONSUMED_PARAMETER_PREDICATE;
    }

    public static FluentIterable<Parameter> getHeaderParameters(ResourceMethod resourceMethod) {
        return FluentIterable.from((Iterable)resourceMethod.getInvocable().getParameters()).filter(Utilities.isHeaderParameterPredicate());
    }

    public static Predicate<Parameter> isHeaderParameterPredicate() {
        return IS_HEADER_PARAMETER_PREDICATE;
    }

    public static FluentIterable<JaxRsHeaderParameter> toJaxRsHeaderParameters(Iterable<Parameter> headerParameters) {
        return FluentIterable.from(headerParameters).transform((Function)new Function<Parameter, JaxRsHeaderParameter>(){

            @Nullable
            public JaxRsHeaderParameter apply(@Nullable Parameter parameter) {
                return JerseyJaxRsHeaderParameter.create(parameter);
            }
        });
    }

    public static Optional<JaxRsEntity> toJaxRsEntityParameters(Iterable<Parameter> consumedParameter, final SourceParser parser) {
        return FluentIterable.from(consumedParameter).transform((Function)new Function<Parameter, JaxRsEntity>(){

            @Nullable
            public JaxRsEntity apply(@Nullable Parameter input) {
                return JerseyJaxRsEntity.create(input, parser);
            }
        }).first();
    }

    public static Optional<JaxRsEntity> getReturnValue(ResourceMethod resourceMethod, SourceParser sourceParser) {
        return JerseyJaxRsEntity.create(resourceMethod.getInvocable().getResponseType(), sourceParser);
    }

    public static FluentIterable<JaxRsFormParameter> toJaxRsFormParameters(Iterable<Parameter> formParameters) {
        return FluentIterable.from(formParameters).transform((Function)new Function<Parameter, JaxRsFormParameter>(){

            @Nullable
            public JaxRsFormParameter apply(@Nullable Parameter input) {
                return JerseyJaxRsFormParameter.create(input);
            }
        });
    }

    public static FluentIterable<JaxRsMultiPartFormDataParameter> toJaxRsMultiPartFormDataParameter(Iterable<Parameter> multiPartFormDataParameter, final SourceParser sourceParser) {
        return FluentIterable.from(multiPartFormDataParameter).transform((Function)new Function<Parameter, JaxRsMultiPartFormDataParameter>(){

            @Nullable
            public JaxRsMultiPartFormDataParameter apply(@Nullable Parameter input) {
                return JerseyJaxRsMultiPartFormDataParameter.create(input, sourceParser);
            }
        });
    }
}

