/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.converter;

import java.io.IOException;
import org.raml.api.RamlApi;
import org.raml.jaxrs.converter.JaxRsToRamlConversionException;
import org.raml.jaxrs.converter.RamlConfiguration;
import org.raml.jaxrs.converter.model.JaxRsRamlApi;
import org.raml.jaxrs.model.JaxRsApplication;
import org.raml.jaxrs.model.JaxRsResource;
import org.raml.utilities.IndentedAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsToRamlConverter {
    private static final Logger logger = LoggerFactory.getLogger(JaxRsToRamlConverter.class);

    private JaxRsToRamlConverter() {
    }

    public static JaxRsToRamlConverter create() {
        return new JaxRsToRamlConverter();
    }

    public RamlApi convert(RamlConfiguration configuration, JaxRsApplication application) throws JaxRsToRamlConversionException {
        if (logger.isDebugEnabled()) {
            logger.debug("converting application: \n{}", (Object)JaxRsToRamlConverter.jaxRsApplicationPrettyString(application));
        }
        return JaxRsRamlApi.create(configuration, application);
    }

    private static String jaxRsApplicationPrettyString(JaxRsApplication application) {
        StringBuilder builder = new StringBuilder();
        try {
            JaxRsToRamlConverter.appendApplication(IndentedAppendable.forNoSpaces((int)2, (Appendable)builder), application);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    private static IndentedAppendable appendApplication(IndentedAppendable appendable, JaxRsApplication application) throws IOException {
        appendable.appendLine("JaxRsApplication {");
        appendable.indent();
        for (JaxRsResource resource : application.getResources()) {
            JaxRsToRamlConverter.appendResource(appendable, resource);
        }
        appendable.outdent();
        appendable.withIndent().append((CharSequence)"}");
        return appendable;
    }

    private static IndentedAppendable appendResource(IndentedAppendable appendable, JaxRsResource resource) throws IOException {
        appendable.appendLine("Resource {");
        appendable.indent();
        appendable.appendLine("path: " + resource.getPath().getStringRepresentation());
        appendable.outdent();
        appendable.appendLine("}");
        return appendable;
    }
}

