/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.converter.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import org.raml.api.RamlHeaderParameter;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlQueryParameter;
import org.raml.api.RamlResourceMethod;
import org.raml.jaxrs.converter.model.Utilities;
import org.raml.jaxrs.model.JaxRsMethod;

public class JaxRsRamlMethod
implements RamlResourceMethod {
    private final JaxRsMethod resourceMethod;

    private JaxRsRamlMethod(JaxRsMethod resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    public static JaxRsRamlMethod create(JaxRsMethod resourceMethod) {
        Preconditions.checkNotNull((Object)resourceMethod);
        return new JaxRsRamlMethod(resourceMethod);
    }

    public String getHttpMethod() {
        return this.resourceMethod.getHttpVerb().getString().toLowerCase();
    }

    public List<RamlMediaType> getConsumedMediaTypes() {
        return Utilities.toRamlMediaTypes(this.resourceMethod.getConsumedMediaTypes()).toList();
    }

    public List<RamlMediaType> getProducedMediaTypes() {
        return Utilities.toRamlMediaTypes(this.resourceMethod.getProducedMediaTypes()).toList();
    }

    public List<RamlQueryParameter> getQueryParameters() {
        return Utilities.toRamlQueryParameters(this.resourceMethod.getQueryParameters()).toList();
    }

    public List<RamlHeaderParameter> getHeaderParameters() {
        return Utilities.toRamlHeaderParameters(this.resourceMethod.getHeaderParameters()).toList();
    }

    public Optional<String> getDescription() {
        return this.resourceMethod.getDescription();
    }
}

