/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.converter.model;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.raml.api.RamlHeaderParameter;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlQueryParameter;
import org.raml.api.RamlResource;
import org.raml.api.RamlResourceMethod;
import org.raml.jaxrs.converter.model.JaxRsRamlHeaderParameter;
import org.raml.jaxrs.converter.model.JaxRsRamlMediaType;
import org.raml.jaxrs.converter.model.JaxRsRamlMethod;
import org.raml.jaxrs.converter.model.JaxRsRamlQueryParameter;
import org.raml.jaxrs.converter.model.JaxRsRamlResource;
import org.raml.jaxrs.model.JaxRsHeaderParameter;
import org.raml.jaxrs.model.JaxRsMethod;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.model.JaxRsResource;

public class Utilities {
    public static FluentIterable<RamlMediaType> toRamlMediaTypes(Iterable<MediaType> mediaTypes) {
        return FluentIterable.from(mediaTypes).transform((Function)new Function<MediaType, RamlMediaType>(){

            public RamlMediaType apply(MediaType mediaType) {
                return JaxRsRamlMediaType.create(mediaType);
            }
        });
    }

    public static FluentIterable<RamlResource> toRamlResources(Iterable<JaxRsResource> jaxRsResources) {
        return FluentIterable.from(jaxRsResources).transform((Function)new Function<JaxRsResource, RamlResource>(){

            public RamlResource apply(JaxRsResource jaxRsResource) {
                return JaxRsRamlResource.create(jaxRsResource);
            }
        });
    }

    public static FluentIterable<RamlResourceMethod> toRamlMethods(Iterable<JaxRsMethod> methods) {
        return FluentIterable.from(methods).transform((Function)new Function<JaxRsMethod, RamlResourceMethod>(){

            public RamlResourceMethod apply(JaxRsMethod method) {
                return JaxRsRamlMethod.create(method);
            }
        });
    }

    public static FluentIterable<RamlQueryParameter> toRamlQueryParameters(Iterable<JaxRsQueryParameter> queryParameters) {
        return FluentIterable.from(queryParameters).transform((Function)new Function<JaxRsQueryParameter, RamlQueryParameter>(){

            public RamlQueryParameter apply(JaxRsQueryParameter queryParameter) {
                return JaxRsRamlQueryParameter.create(queryParameter);
            }
        });
    }

    public static FluentIterable<RamlHeaderParameter> toRamlHeaderParameters(List<JaxRsHeaderParameter> headerParameters) {
        return FluentIterable.from(headerParameters).transform((Function)new Function<JaxRsHeaderParameter, RamlHeaderParameter>(){

            public RamlHeaderParameter apply(JaxRsHeaderParameter jaxRsHeaderParameter) {
                return JaxRsRamlHeaderParameter.create(jaxRsHeaderParameter);
            }
        });
    }
}

