/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.converter.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.List;
import org.raml.api.RamlEntity;
import org.raml.api.RamlFormParameter;
import org.raml.api.RamlHeaderParameter;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlMultiFormDataParameter;
import org.raml.api.RamlQueryParameter;
import org.raml.api.RamlResourceMethod;
import org.raml.jaxrs.converter.model.JaxRsRamlEntity;
import org.raml.jaxrs.converter.model.Utilities;
import org.raml.jaxrs.model.JaxRsEntity;
import org.raml.jaxrs.model.JaxRsMethod;

public class JaxRsRamlMethod
implements RamlResourceMethod {
    private final JaxRsMethod resourceMethod;

    private JaxRsRamlMethod(JaxRsMethod resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    public static JaxRsRamlMethod create(JaxRsMethod resourceMethod) {
        Preconditions.checkNotNull((Object)resourceMethod);
        return new JaxRsRamlMethod(resourceMethod);
    }

    public String getHttpMethod() {
        return this.resourceMethod.getHttpVerb().getString().toLowerCase();
    }

    public List<RamlMediaType> getConsumedMediaTypes() {
        return Utilities.toRamlMediaTypes(this.resourceMethod.getConsumedMediaTypes()).toList();
    }

    public List<RamlMediaType> getProducedMediaTypes() {
        return Utilities.toRamlMediaTypes(this.resourceMethod.getProducedMediaTypes()).toList();
    }

    public List<RamlQueryParameter> getQueryParameters() {
        return Utilities.toRamlQueryParameters(this.resourceMethod.getQueryParameters()).toList();
    }

    public List<RamlHeaderParameter> getHeaderParameters() {
        return Utilities.toRamlHeaderParameters(this.resourceMethod.getHeaderParameters()).toList();
    }

    public List<RamlFormParameter> getFormParameters() {
        return Utilities.toRamlFormParameters(this.resourceMethod.getFormParameters()).toList();
    }

    public Optional<RamlEntity> getConsumedType() {
        return this.resourceMethod.getConsumedEntity().transform((Function)new Function<JaxRsEntity, RamlEntity>(){

            public RamlEntity apply(JaxRsEntity input) {
                return JaxRsRamlEntity.create(input);
            }
        });
    }

    public List<RamlMultiFormDataParameter> getMultiFormDataParameter() {
        return Utilities.toRamlMultiPartFormDataParameters(this.resourceMethod.getMultiPartFormDataParameters()).toList();
    }

    public Optional<RamlEntity> getProducedType() {
        return this.resourceMethod.getProducedEntity().transform((Function)new Function<JaxRsEntity, RamlEntity>(){

            public RamlEntity apply(JaxRsEntity input) {
                return JaxRsRamlEntity.create(input);
            }
        });
    }

    public Optional<String> getDescription() {
        return this.resourceMethod.getDescription();
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return this.resourceMethod.getJavaAnnotation(annotationType);
    }
}

