/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.NoSuchElementException;

public enum HttpVerb {
    GET("GET"),
    PUT("PUT"),
    POST("POST"),
    HEAD("HEAD"),
    OPTIONS("OPTIONS"),
    PATCH("PATCH"),
    DELETE("DELETE");

    private static final ImmutableMap<String, HttpVerb> VERBS_BY_STRINGS;
    private final String string;

    private HttpVerb(String string2) {
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public static Optional<HttpVerb> fromString(String httpMethod) {
        return Optional.fromNullable((Object)VERBS_BY_STRINGS.get((Object)httpMethod));
    }

    public static HttpVerb fromStringUnchecked(String httpMethod) {
        Optional<HttpVerb> verb = HttpVerb.fromString(httpMethod);
        if (verb.isPresent()) {
            return (HttpVerb)((Object)verb.get());
        }
        throw new NoSuchElementException(String.format("invalid http method: %s", httpMethod));
    }

    static {
        ImmutableMap.Builder tempMap = ImmutableMap.builder();
        for (HttpVerb verb : HttpVerb.values()) {
            tempMap.put((Object)verb.getString(), (Object)verb);
        }
        VERBS_BY_STRINGS = tempMap.build();
    }
}

