/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;

public class ResourceUtils {
    public static void fillInBodiesAndResponses(GResource resource, Multimap<GMethod, GRequest> incomingBodies, Multimap<GMethod, GResponse> responses) {
        for (GMethod method : resource.methods()) {
            if (method.body().size() == 0) {
                incomingBodies.put((Object)method, null);
            } else {
                for (GRequest typeDeclaration : method.body()) {
                    incomingBodies.put((Object)method, (Object)typeDeclaration);
                }
            }
            if (method.responses().size() == 0) {
                incomingBodies.put((Object)method, null);
                continue;
            }
            for (GResponse response : method.responses()) {
                responses.put((Object)method, (Object)response);
            }
        }
    }

    public static List<GParameter> accumulateUriParameters(GResource resource) {
        ArrayList<GParameter> parameters = new ArrayList<GParameter>();
        parameters.addAll(Lists.reverse(resource.uriParameters()));
        while (resource.parentResource() != null) {
            resource = resource.parentResource();
            parameters.addAll(Lists.reverse(resource.uriParameters()));
        }
        Collections.reverse(parameters);
        return parameters;
    }
}

