/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ScalarTypes {
    private static Map<Class, Class<?>> scalarToType = ImmutableMap.builder().put(IntegerTypeDeclaration.class, Integer.TYPE).put(BooleanTypeDeclaration.class, Boolean.TYPE).put(DateTimeOnlyTypeDeclaration.class, Date.class).put(TimeOnlyTypeDeclaration.class, Date.class).put(DateTimeTypeDeclaration.class, Date.class).put(DateTypeDeclaration.class, Date.class).put(NumberTypeDeclaration.class, BigDecimal.class).put(StringTypeDeclaration.class, String.class).put(FileTypeDeclaration.class, File.class).put(AnyTypeDeclaration.class, Object.class).build();
    private static Map<String, Class<?>> stringScalarToType = ImmutableMap.builder().put((Object)"integer", Integer.TYPE).put((Object)"boolean", Boolean.TYPE).put((Object)"date-time", Date.class).put((Object)"date", Date.class).put((Object)"number", BigDecimal.class).put((Object)"string", String.class).put((Object)"file", File.class).build();
    private static Map<String, Class<?>> properType = ImmutableMap.builder().put((Object)"float", Float.TYPE).put((Object)"double", Double.TYPE).put((Object)"int8", Byte.TYPE).put((Object)"int16", Short.TYPE).put((Object)"int32", Integer.TYPE).put((Object)"int64", Long.TYPE).put((Object)"int", Integer.TYPE).build();
    private static Map<String, Class<?>> properTypeObject = ImmutableMap.builder().put((Object)"float", Float.class).put((Object)"double", Double.class).put((Object)"int8", Byte.class).put((Object)"int16", Short.class).put((Object)"int32", Integer.class).put((Object)"int64", Long.class).put((Object)"int", Integer.class).build();

    public static Class<?> scalarToJavaType(TypeDeclaration type) {
        if (type instanceof IntegerTypeDeclaration) {
            return ScalarTypes.properType(ScalarTypes.shouldUsePrimitiveType((NumberTypeDeclaration)type) ? Integer.TYPE : Integer.class, (NumberTypeDeclaration)((IntegerTypeDeclaration)type));
        }
        if (type instanceof NumberTypeDeclaration) {
            return ScalarTypes.properType(BigDecimal.class, (NumberTypeDeclaration)type);
        }
        if (type instanceof BooleanTypeDeclaration) {
            return ScalarTypes.shouldUsePrimitiveType((BooleanTypeDeclaration)type) ? Boolean.TYPE : Boolean.class;
        }
        return scalarToType.get(type.getClass().getInterfaces()[0]);
    }

    private static Class<?> properType(Class<?> defaultClass, NumberTypeDeclaration type) {
        if (type.format() == null) {
            return defaultClass;
        }
        if (ScalarTypes.shouldUsePrimitiveType(type)) {
            return properType.get(type.format());
        }
        return properTypeObject.get(type.format());
    }

    private static boolean shouldUsePrimitiveType(NumberTypeDeclaration type) {
        Boolean shouldUse = Annotations.USE_PRIMITIVE_TYPE.get((Annotable)type, new Annotable[0]);
        if (shouldUse != null && shouldUse.booleanValue()) {
            return true;
        }
        return type.required();
    }

    private static boolean shouldUsePrimitiveType(BooleanTypeDeclaration type) {
        Boolean shouldUse = Annotations.USE_PRIMITIVE_TYPE.get((Annotable)type, new Annotable[0]);
        if (shouldUse != null && shouldUse.booleanValue()) {
            return true;
        }
        return type.required();
    }

    public static Class<?> scalarToJavaType(String name) {
        return stringScalarToType.get(name.toLowerCase());
    }

    public static Class<?> scalarToJavaType(GType type) {
        if (type.isEnum()) {
            return null;
        }
        if (type instanceof V10GType) {
            return ScalarTypes.scalarToJavaType((TypeDeclaration)type.implementation());
        }
        return ScalarTypes.scalarToJavaType(type.name());
    }

    public static boolean extendsScalarRamlType(TypeDeclaration typeDeclaration) {
        return ScalarTypes.scalarToJavaType(typeDeclaration.name()) != null;
    }

    public static boolean isArray(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof ArrayTypeDeclaration;
    }

    public static TypeName classToTypeName(Class scalar) {
        if (scalar.isPrimitive()) {
            switch (scalar.getSimpleName()) {
                case "int": {
                    return TypeName.INT;
                }
                case "boolean": {
                    return TypeName.BOOLEAN;
                }
                case "double": {
                    return TypeName.DOUBLE;
                }
                case "float": {
                    return TypeName.FLOAT;
                }
                case "byte": {
                    return TypeName.BYTE;
                }
                case "char": {
                    return TypeName.CHAR;
                }
                case "short": {
                    return TypeName.SHORT;
                }
                case "long": {
                    return TypeName.LONG;
                }
                case "void": {
                    return TypeName.VOID;
                }
            }
            throw new GenerationException("can't handle type: " + scalar);
        }
        return ClassName.get((Class)scalar);
    }
}

