/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.typegenerators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.extension.types.PredefinedFieldType;
import org.raml.jaxrs.generator.extension.types.TypeContext;
import org.raml.jaxrs.generator.extension.types.UnionExtension;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.jaxrs.generator.v10.types.V10GTypeUnion;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

class SimpleUnionExtension
implements UnionExtension {
    private ClassName javaName;
    private V10TypeRegistry registry;

    public SimpleUnionExtension(ClassName javaName, V10TypeRegistry registry) {
        this.javaName = javaName;
        this.registry = registry;
    }

    @Override
    public TypeSpec.Builder onUnionType(TypeContext context, TypeSpec.Builder noBuilder, V10GTypeUnion currentType, BuildPhase btype) {
        UnionTypeDeclaration union = (UnionTypeDeclaration)currentType.implementation();
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)this.javaName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        typeSpec = Annotations.ON_TYPE_CLASS_FINISH.get(currentType).onType(context, typeSpec, currentType, btype);
        context.onType(context, typeSpec, currentType, btype);
        FieldSpec.Builder anyType = FieldSpec.builder(Object.class, (String)"anyType", (Modifier[])new Modifier[]{Modifier.PRIVATE});
        anyType = context.onField(context, typeSpec, anyType, currentType, null, BuildPhase.INTERFACE, PredefinedFieldType.UNION);
        anyType = Annotations.ON_TYPE_FIELD_CREATION.get(currentType).onField(context, typeSpec, anyType, currentType, null, BuildPhase.INTERFACE, PredefinedFieldType.UNION);
        typeSpec.addField(anyType.build());
        typeSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("this.anyType = null", new Object[0]).build());
        for (TypeDeclaration typeDeclaration : union.of()) {
            V10GType type = this.registry.fetchType(typeDeclaration);
            TypeName typeName = type.defaultJavaTypeName(context.getModelPackage());
            String fieldName = Names.methodName(typeDeclaration.name());
            typeSpec.addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)typeName, (String)fieldName, (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.anyType = $L", new Object[]{fieldName}).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", typeDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName).addStatement("if ( !(anyType instanceof  $T)) throw new $T(\"fetching wrong type out of the union: $T\")", new Object[]{typeName, IllegalStateException.class, typeName}).addStatement("return ($T) anyType", new Object[]{typeName}).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("is", typeDeclaration.name())).addStatement("return anyType instanceof $T", new Object[]{typeName}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).build());
        }
        return typeSpec;
    }
}

