/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

public interface NameFixer {
    public static final NameFixer CAMEL_LOWER = new NameFixer(){

        @Override
        public String fixFirst(String name) {
            return Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }

        @Override
        public String fixOthers(String name) {
            return CAMEL_UPPER.fixOthers(name);
        }
    };
    public static final NameFixer CAMEL_UPPER = new NameFixer(){

        @Override
        public String fixFirst(String name) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }

        @Override
        public String fixOthers(String name) {
            return this.fixFirst(name);
        }
    };
    public static final NameFixer ALL_UPPER = new NameFixer(){

        @Override
        public String fixFirst(String name) {
            return name.toUpperCase();
        }

        @Override
        public String fixOthers(String name) {
            return name.toUpperCase();
        }
    };

    public String fixFirst(String var1);

    public String fixOthers(String var1);
}

