/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GAbstractionFactory;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.v08.V08Finder;
import org.raml.jaxrs.generator.v08.V08TypeRegistry;
import org.raml.jaxrs.generator.v10.ExtensionManager;
import org.raml.jaxrs.generator.v10.ResourceHandler;
import org.raml.jaxrs.generator.v10.V10Finder;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.resources.Resource;

public class RamlScanner {
    private final Configuration configuration;

    public RamlScanner(Configuration configuration) {
        this.configuration = configuration;
    }

    public void handle(File resource) throws IOException, GenerationException {
        this.handle(new FileInputStream(resource), resource.getAbsoluteFile().getParentFile());
    }

    public void handle(InputStream stream, File ramlDirectory) throws GenerationException, IOException {
        RamlModelResult result = new RamlModelBuilder().buildApi((Reader)new InputStreamReader(stream), ramlDirectory.getAbsolutePath() + "/");
        if (result.hasErrors()) {
            throw new GenerationException(result.getValidationResults());
        }
        if (result.isVersion08()) {
            this.handle(result.getApiV08(), ramlDirectory);
        } else {
            this.handle(result.getApiV10(), ramlDirectory);
        }
    }

    public void handle(Api api, File ramlDirectory) throws IOException {
        V10TypeRegistry registry = new V10TypeRegistry();
        CurrentBuild build = new CurrentBuild(new V10Finder(api, registry), api, ExtensionManager.createExtensionManager(), ramlDirectory);
        this.configuration.setupBuild(build);
        build.constructClasses();
        ResourceHandler resourceHandler = new ResourceHandler(build);
        for (Resource resource : api.resources()) {
            resourceHandler.handle(registry, resource);
        }
        build.generate(this.configuration.getOutputDirectory());
    }

    public void handle(org.raml.v2.api.model.v08.api.Api api, File ramlDirectory) throws IOException {
        GAbstractionFactory factory = new GAbstractionFactory();
        V08TypeRegistry registry = new V08TypeRegistry();
        V08Finder typeFinder = new V08Finder(api, factory, registry);
        CurrentBuild build = new CurrentBuild(typeFinder, null, ExtensionManager.createExtensionManager(), ramlDirectory);
        this.configuration.setupBuild(build);
        build.constructClasses();
        ResourceHandler resourceHandler = new ResourceHandler(build);
        for (org.raml.v2.api.model.v08.resources.Resource resource : api.resources()) {
            resourceHandler.handle(typeFinder.globalSchemas().keySet(), registry, resource);
        }
        build.generate(this.configuration.getOutputDirectory());
    }
}

