/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types;

import com.squareup.javapoet.TypeSpec;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.extension.types.TypeContext;
import org.raml.jaxrs.generator.extension.types.TypeExtension;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JavadocTypeExtension
implements TypeExtension {
    public void javadocExamples(JavadocAdder adder, TypeDeclaration typeDeclaration) {
        ExampleSpec example = typeDeclaration.example();
        if (example != null) {
            this.javadoc(adder, example);
        }
        for (ExampleSpec exampleSpec : typeDeclaration.examples()) {
            this.javadoc(adder, exampleSpec);
        }
    }

    @Override
    public TypeSpec.Builder onType(TypeContext context, final TypeSpec.Builder typeSpec, V10GType type, BuildPhase btype) {
        if (type.implementation().description() != null) {
            typeSpec.addJavadoc("$L\n", new Object[]{type.implementation().description().value()});
        }
        this.javadocExamples(new JavadocAdder(){

            @Override
            public void addJavadoc(String format, Object ... args) {
                typeSpec.addJavadoc(format, args);
            }
        }, type.implementation());
        return null;
    }

    public void javadoc(JavadocAdder adder, ExampleSpec exampleSpec) {
        adder.addJavadoc("Example:\n", new Object[0]);
        if (exampleSpec.name() != null) {
            adder.addJavadoc(" $L\n", exampleSpec.name());
        }
        adder.addJavadoc(" $L\n", "<pre>\n{@code\n" + exampleSpec.value() + "\n}</pre>");
    }

    private static interface JavadocAdder {
        public void addJavadoc(String var1, Object ... var2);
    }
}

