/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.extensions.types.TypeExtensionHelper;
import org.raml.jaxrs.generator.extension.types.FieldType;
import org.raml.jaxrs.generator.extension.types.PredefinedFieldType;
import org.raml.jaxrs.generator.extension.types.TypeContext;
import org.raml.jaxrs.generator.v10.V10GProperty;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class JaxbTypeExtension
extends TypeExtensionHelper {
    @Override
    public void onEnumConstant(CurrentBuild currentBuild, TypeSpec.Builder builder, TypeDeclaration typeDeclaration, String name) {
        builder.addAnnotation(AnnotationSpec.builder(XmlEnumValue.class).addMember("value", "$S", new Object[]{name}).build());
    }

    @Override
    public void onEnumerationClass(CurrentBuild currentBuild, TypeSpec.Builder builder, TypeDeclaration typeDeclaration) {
        builder.addAnnotation(AnnotationSpec.builder(XmlEnum.class).build());
    }

    @Override
    public TypeSpec.Builder onType(TypeContext context, TypeSpec.Builder builder, V10GType type, BuildPhase buildPhase) {
        String name;
        String namespace = type.xml().namespace() != null ? type.xml().namespace() : "##default";
        String string = name = type.xml().name() != null ? type.xml().name() : type.name();
        if (buildPhase == BuildPhase.IMPLEMENTATION) {
            builder.addAnnotation(AnnotationSpec.builder(XmlAccessorType.class).addMember("value", "$T.$L", new Object[]{XmlAccessType.class, "FIELD"}).build());
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(XmlRootElement.class).addMember("namespace", "$S", new Object[]{namespace}).addMember("name", "$S", new Object[]{name});
            builder.addAnnotation(annotation.build());
        } else {
            builder.addAnnotation(AnnotationSpec.builder(XmlRootElement.class).addMember("namespace", "$S", new Object[]{namespace}).addMember("name", "$S", new Object[]{name}).build());
        }
        return builder;
    }

    @Override
    public FieldSpec.Builder onField(TypeContext context, TypeSpec.Builder typeSpec, FieldSpec.Builder fieldSpec, V10GType containingType, V10GProperty property, BuildPhase buildPhase, FieldType fieldType) {
        if (fieldType == PredefinedFieldType.PROPERTY && buildPhase == BuildPhase.IMPLEMENTATION) {
            String name;
            String namespace = property.xml().namespace() != null ? property.xml().namespace() : "##default";
            String string = name = property.xml().name() != null ? property.xml().name() : property.name();
            if (property.xml().wrapped() != null && property.xml().wrapped().booleanValue() && property.type().isArray()) {
                fieldSpec.addAnnotation(AnnotationSpec.builder(XmlElementWrapper.class).addMember("name", "$S", new Object[]{name}).build());
                if (property.xml().attribute() != null && property.xml().attribute().booleanValue()) {
                    fieldSpec.addAnnotation(AnnotationSpec.builder(XmlAttribute.class).addMember("name", "$S", new Object[]{property.type().arrayContents().name()}).addMember("namespace", "$S", new Object[]{namespace}).build());
                } else {
                    fieldSpec.addAnnotation(AnnotationSpec.builder(XmlElement.class).addMember("name", "$S", new Object[]{property.type().arrayContents().name()}).addMember("namespace", "$S", new Object[]{namespace}).build());
                }
            } else if (property.xml().attribute().booleanValue()) {
                fieldSpec.addAnnotation(AnnotationSpec.builder(XmlAttribute.class).addMember("name", "$S", new Object[]{name}).addMember("namespace", "$S", new Object[]{namespace}).build());
            } else {
                fieldSpec.addAnnotation(AnnotationSpec.builder(XmlElement.class).addMember("name", "$S", new Object[]{name}).addMember("namespace", "$S", new Object[]{namespace}).build());
            }
        }
        if (fieldType == PredefinedFieldType.UNION) {
            UnionTypeDeclaration union = (UnionTypeDeclaration)containingType.implementation();
            AnnotationSpec.Builder elementsAnnotation = AnnotationSpec.builder(XmlElements.class);
            for (TypeDeclaration typeDeclaration : union.of()) {
                elementsAnnotation.addMember("value", "$L", new Object[]{AnnotationSpec.builder(XmlElement.class).addMember("name", "$S", new Object[]{typeDeclaration.name()}).addMember("type", "$T.class", new Object[]{ClassName.get((String)context.getModelPackage(), (String)(typeDeclaration.name() + "Impl"), (String[])new String[0])}).build()});
            }
            fieldSpec.addAnnotation(elementsAnnotation.build());
        }
        return fieldSpec;
    }
}

