/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types.jackson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.builders.extensions.types.TypeExtensionHelper;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JacksonBasicExtension
extends TypeExtensionHelper {
    public static final ParameterizedTypeName ADDITIONAL_PROPERTIES_TYPE = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class});

    @Override
    public void onTypeImplementation(CurrentBuild currentBuild, TypeSpec.Builder typeSpec, TypeDeclaration typeDeclaration) {
        ObjectTypeDeclaration obj = (ObjectTypeDeclaration)typeDeclaration;
        typeSpec.addAnnotation(AnnotationSpec.builder(JsonInclude.class).addMember("value", "$T.$L", new Object[]{JsonInclude.Include.class, "NON_NULL"}).build());
        if (obj.discriminatorValue() != null) {
            typeSpec.addAnnotation(AnnotationSpec.builder(JsonTypeName.class).addMember("value", "$S", new Object[]{obj.discriminatorValue()}).build());
        }
        AnnotationSpec.Builder builder = AnnotationSpec.builder(JsonPropertyOrder.class);
        for (TypeDeclaration declaration : obj.properties()) {
            builder.addMember("value", "$S", new Object[]{declaration.name()});
        }
        typeSpec.addAnnotation(builder.build());
        typeSpec.addField(FieldSpec.builder((TypeName)ADDITIONAL_PROPERTIES_TYPE, (String)"additionalProperties", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(JsonIgnore.class).build()).initializer(CodeBlock.of((String)"new $T()", (Object[])new Object[]{ParameterizedTypeName.get(HashMap.class, (Type[])new Type[]{String.class, Object.class})})).build());
        typeSpec.addMethod(MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("return additionalProperties;\n", new Object[0]).addAnnotation(JsonAnyGetter.class).build());
        typeSpec.addMethod(MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ADDITIONAL_PROPERTIES_TYPE, (String)"additionalProperties", (Modifier[])new Modifier[0]).build()).addAnnotation(JsonAnySetter.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().add("this.additionalProperties = additionalProperties;\n", new Object[0]).build()).build());
    }

    @Override
    public void onFieldImplementation(CurrentBuild currentBuild, FieldSpec.Builder fieldSpec, TypeDeclaration typeDeclaration) {
        fieldSpec.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{typeDeclaration.name()}).build());
    }

    @Override
    public void onGetterMethodImplementation(CurrentBuild currentBuild, MethodSpec.Builder methodSpec, TypeDeclaration typeDeclaration) {
        methodSpec.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{typeDeclaration.name()}).build());
    }

    @Override
    public void onSetterMethodImplementation(CurrentBuild currentBuild, MethodSpec.Builder methodSpec, ParameterSpec.Builder param, TypeDeclaration typeDeclaration) {
        methodSpec.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{typeDeclaration.name()}).build());
    }

    @Override
    public void onTypeDeclaration(CurrentBuild currentBuild, TypeSpec.Builder typeSpec, V10GType type) {
        typeSpec.addMethod(MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        typeSpec.addMethod(MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ADDITIONAL_PROPERTIES_TYPE, (String)"additionalProperties", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
    }
}

