/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class UnionSerializationGenerator
implements JavaPoetTypeGenerator {
    private final CurrentBuild currentBuild;
    private final V10GType unionTypeDeclaration;
    private final ClassName deserializer;

    public UnionSerializationGenerator(CurrentBuild currentBuild, V10GType unionTypeDeclaration, ClassName deserializer) {
        this.currentBuild = currentBuild;
        this.unionTypeDeclaration = unionTypeDeclaration;
        this.deserializer = deserializer;
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
        UnionTypeDeclaration union = (UnionTypeDeclaration)this.unionTypeDeclaration.implementation();
        ClassName unionTypeName = ClassName.get((String)this.currentBuild.getModelPackage(), (String)Names.typeName(this.unionTypeDeclaration.name()), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.deserializer).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdSerializer.class), (TypeName[])new TypeName[]{unionTypeName})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super($T.class);", new Object[]{unionTypeName}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder serialize = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)unionTypeName, (String)"object", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonGenerator.class), (String)"jsonGenerator", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(SerializerProvider.class), (String)"jsonSerializerProvider", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class);
        for (TypeDeclaration typeDeclaration : union.of()) {
            String isMethod = Names.methodName("is", typeDeclaration.name());
            String getMethod = Names.methodName("get", typeDeclaration.name());
            serialize.beginControlFlow("if ( object." + isMethod + "())", new Object[0]);
            serialize.addStatement("jsonGenerator.writeObject(object." + getMethod + "())", new Object[0]);
            serialize.addStatement("return", new Object[0]);
            serialize.endControlFlow();
        }
        serialize.addStatement("throw new $T($S + object)", new Object[]{IOException.class, "Can't figure out type of object"});
        builder.addMethod(serialize.build());
        rootDirectory.into(builder);
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory, BuildPhase buildPhase) throws IOException {
        this.output(rootDirectory);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.deserializer;
    }
}

