/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;

public abstract class AbstractCompositeExtension<T, B> {
    private List<T> elements;

    public AbstractCompositeExtension(List<T> elements) {
        this.elements = elements;
    }

    @VisibleForTesting
    public List<T> getElements() {
        return this.elements;
    }

    public B runList(B input, ElementJob<T, B> job) {
        B current = input;
        for (T element : this.elements) {
            current = job.doElement(element, current);
            if (current != null) continue;
            return null;
        }
        return current;
    }

    protected static interface ElementJob<T, B> {
        public B doElement(T var1, B var2);
    }
}

