/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension.resources;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import javax.validation.Valid;
import org.raml.jaxrs.generator.extension.resources.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.ResourceContext;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;

public class Jsr303ResourceExtension
implements GlobalResourceExtension {
    @Override
    public TypeSpec.Builder onResource(ResourceContext context, GResource resource, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GMethod method, MethodSpec.Builder methodSpec) {
        MethodSpec spec = methodSpec.build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)spec.name);
        builder.addAnnotations((Iterable)spec.annotations);
        if (spec.code != null) {
            builder.addCode(spec.code);
        }
        if (spec.defaultValue != null) {
            builder.defaultValue(spec.defaultValue);
        }
        builder.addExceptions((Iterable)spec.exceptions);
        if (spec.javadoc != null) {
            builder.addJavadoc("$L", new Object[]{spec.javadoc});
        }
        builder.addModifiers((Iterable)spec.modifiers);
        for (ParameterSpec parameter : spec.parameters) {
            if (!(parameter.type.isPrimitive() || parameter.type.isBoxedPrimitive() || parameter.type.withoutAnnotations().toString().equals("java.lang.String"))) {
                builder.addParameter(parameter.toBuilder().addAnnotation(Valid.class).build());
                continue;
            }
            builder.addParameter(parameter);
        }
        if (spec.returnType != null) {
            builder.returns(spec.returnType);
        }
        builder.addTypeVariables((Iterable)spec.typeVariables);
        builder.varargs(spec.varargs);
        return builder;
    }

    @Override
    public TypeSpec.Builder onResponseClass(ResourceContext context, GMethod method, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GResponse responseMethod, MethodSpec.Builder methodSpec) {
        return methodSpec;
    }
}

