/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v08;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v08.V08GParameter;
import org.raml.jaxrs.generator.v08.V08GRequest;
import org.raml.jaxrs.generator.v08.V08GResource;
import org.raml.jaxrs.generator.v08.V08Response;
import org.raml.jaxrs.generator.v08.V08TypeRegistry;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.bodies.Response;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.parameters.Parameter;

public class V08Method
implements GMethod {
    private final V08GResource v08GResource;
    private final List<GParameter> queryParameters;
    private final List<GResponse> responses;
    private final Method input;
    private final List<GParameter> headers;
    private List<GRequest> requests;

    public V08Method(final V08GResource v08GResource, final Method input, final Set<String> globalSchemas, final V08TypeRegistry registry) {
        this.v08GResource = v08GResource;
        this.queryParameters = Lists.transform((List)input.queryParameters(), (Function)new Function<Parameter, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable Parameter input) {
                return new V08GParameter(input);
            }
        });
        this.headers = Lists.transform((List)input.headers(), (Function)new Function<Parameter, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable Parameter input) {
                return new V08GParameter(input);
            }
        });
        this.requests = Lists.transform((List)input.body(), (Function)new Function<BodyLike, GRequest>(){

            @Nullable
            public GRequest apply(@Nullable BodyLike input) {
                return new V08GRequest(V08Method.this.v08GResource, V08Method.this, input, globalSchemas, registry);
            }
        });
        this.responses = Lists.transform((List)input.responses(), (Function)new Function<Response, GResponse>(){

            @Nullable
            public GResponse apply(@Nullable Response resp) {
                return new V08Response(v08GResource.implementation(), input, resp, globalSchemas, registry);
            }
        });
        this.input = input;
    }

    public Method implementation() {
        return this.input;
    }

    @Override
    public List<GRequest> body() {
        return this.requests;
    }

    @Override
    public GResource resource() {
        return this.v08GResource;
    }

    @Override
    public String method() {
        return this.input.method();
    }

    @Override
    public List<GParameter> queryParameters() {
        return this.queryParameters;
    }

    @Override
    public List<GResponse> responses() {
        return this.responses;
    }

    @Override
    public List<GParameter> headers() {
        return this.headers;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof V08Method)) {
            return false;
        }
        V08Method method = (V08Method)obj;
        return method.v08GResource.resourcePath().equals(this.v08GResource.resourcePath()) && method.method().equals(this.method());
    }

    public int hashCode() {
        return this.method().hashCode() + this.v08GResource.resourcePath().hashCode();
    }
}

