/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v08;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.ramltypes.GResponseType;
import org.raml.jaxrs.generator.v08.V08GParameter;
import org.raml.jaxrs.generator.v08.V08GResponseType;
import org.raml.jaxrs.generator.v08.V08TypeRegistry;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.bodies.Response;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.parameters.Parameter;
import org.raml.v2.api.model.v08.resources.Resource;

public class V08Response
implements GResponse {
    private final Response response;
    private final List<GResponseType> bodies;
    private final List<GParameter> headers;

    public V08Response(final Resource resource, final Method method, Response input, final Set<String> globalSchemas, final V08TypeRegistry registry) {
        this.response = input;
        this.bodies = Lists.transform((List)input.body(), (Function)new Function<BodyLike, GResponseType>(){

            @Nullable
            public GResponseType apply(@Nullable BodyLike input) {
                return new V08GResponseType(resource, method, V08Response.this.response, input, globalSchemas, registry);
            }
        });
        this.headers = Lists.transform((List)this.response.headers(), (Function)new Function<Parameter, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable Parameter parameter) {
                return new V08GParameter(parameter);
            }
        });
    }

    public Response implementation() {
        return this.response;
    }

    @Override
    public List<GResponseType> body() {
        return this.bodies;
    }

    @Override
    public String code() {
        return this.response.code().value();
    }

    @Override
    public List<GParameter> headers() {
        return this.headers;
    }
}

