/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.extension.resources.ResourceClassExtension;
import org.raml.jaxrs.generator.extension.resources.ResourceMethodExtension;
import org.raml.jaxrs.generator.extension.resources.ResponseClassExtension;
import org.raml.jaxrs.generator.extension.resources.ResponseMethodExtension;
import org.raml.jaxrs.generator.extension.types.FieldExtension;
import org.raml.jaxrs.generator.extension.types.MethodExtension;
import org.raml.jaxrs.generator.extension.types.TypeExtension;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v10.V10GMethod;
import org.raml.jaxrs.generator.v10.V10GResource;
import org.raml.jaxrs.generator.v10.V10GResponse;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;

public abstract class Annotations<T> {
    public static Annotations<String> CLASS_NAME = new Annotations<String>(){

        @Override
        public String getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (String)Annotations.getWithDefault("types", "classname", null, target, others);
        }
    };
    public static Annotations<String> IMPLEMENTATION_CLASS_NAME = new Annotations<String>(){

        @Override
        public String getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (String)Annotations.getWithDefault("types", "implementationClassName", null, target, others);
        }
    };
    public static Annotations<Boolean> USE_PRIMITIVE_TYPE = new Annotations<Boolean>(){

        @Override
        public Boolean getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (Boolean)Annotations.getWithDefault("types", "usePrimitiveType", false, target, others);
        }
    };
    public static Annotations<Boolean> ABSTRACT = new Annotations<Boolean>(){

        @Override
        public Boolean getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (Boolean)Annotations.getWithDefault("types", "abstract", false, target, others);
        }
    };
    public static Annotations<ResourceClassExtension<GResource>> ON_RESOURCE_CLASS_CREATION = new Annotations<ResourceClassExtension<GResource>>(){

        @Override
        public ResourceClassExtension<GResource> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("resources", "onResourceClassCreation", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResourceClassExtension.Composite(extension);
        }
    };
    public static Annotations<ResourceClassExtension<GResource>> ON_RESOURCE_CLASS_FINISH = new Annotations<ResourceClassExtension<GResource>>(){

        @Override
        public ResourceClassExtension<GResource> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("resources", "onResourceClassFinish", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResourceClassExtension.Composite(extension);
        }
    };
    public static Annotations<ResourceMethodExtension<GMethod>> ON_METHOD_CREATION = new Annotations<ResourceMethodExtension<GMethod>>(){

        @Override
        public ResourceMethodExtension<GMethod> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("methods", "onResourceMethodCreation", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResourceMethodExtension.Composite(extension);
        }
    };
    public static Annotations<ResourceMethodExtension<GMethod>> ON_METHOD_FINISH = new Annotations<ResourceMethodExtension<GMethod>>(){

        @Override
        public ResourceMethodExtension<GMethod> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("methods", "onResourceMethodFinish", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResourceMethodExtension.Composite(extension);
        }
    };
    public static Annotations<ResponseClassExtension<GMethod>> ON_RESPONSE_CLASS_CREATION = new Annotations<ResponseClassExtension<GMethod>>(){

        @Override
        public ResponseClassExtension<GMethod> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("methods", "onResponseClassCreation", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResponseClassExtension.Composite(extension);
        }
    };
    public static Annotations<ResponseClassExtension<GMethod>> ON_RESPONSE_CLASS_FINISH = new Annotations<ResponseClassExtension<GMethod>>(){

        @Override
        public ResponseClassExtension<GMethod> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("methods", "onResponseClassFinish", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResponseClassExtension.Composite(extension);
        }
    };
    public static Annotations<ResponseMethodExtension<GResponse>> ON_RESPONSE_METHOD_CREATION = new Annotations<ResponseMethodExtension<GResponse>>(){

        @Override
        public ResponseMethodExtension<GResponse> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("responses", "onResponseMethodCreation", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResponseMethodExtension.Composite(extension);
        }
    };
    public static Annotations<ResponseMethodExtension<GResponse>> ON_RESPONSE_METHOD_FINISH = new Annotations<ResponseMethodExtension<GResponse>>(){

        @Override
        public ResponseMethodExtension<GResponse> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("responses", "onResponseMethodFinish", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new ResponseMethodExtension.Composite(extension);
        }
    };
    public static Annotations<TypeExtension> ON_TYPE_CLASS_CREATION = new Annotations<TypeExtension>(){

        @Override
        public TypeExtension getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("types", "onTypeCreation", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new TypeExtension.Composite(extension);
        }
    };
    public static Annotations<TypeExtension> ON_TYPE_CLASS_FINISH = new Annotations<TypeExtension>(){

        @Override
        public TypeExtension getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("types", "onTypeFinish", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new TypeExtension.Composite(extension);
        }
    };
    public static Annotations<FieldExtension> ON_TYPE_FIELD_CREATION = new Annotations<FieldExtension>(){

        @Override
        public FieldExtension getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("types", "onFieldCreation", null, target, others);
            List extensions = Annotations.createExtension(currentBuild, classNames);
            return new FieldExtension.Composite(extensions);
        }
    };
    public static Annotations<MethodExtension> ON_TYPE_METHOD_CREATION = new Annotations<MethodExtension>(){

        @Override
        public MethodExtension getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            List classNames = (List)Annotations.getWithDefault("types", "onMethodCreation", null, target, others);
            List extension = Annotations.createExtension(currentBuild, classNames);
            return new MethodExtension.Composite(extension);
        }
    };

    private static <T> List<T> createExtension(final CurrentBuild currentBuild, List<String> classNames) {
        if (classNames == null) {
            return Collections.emptyList();
        }
        return FluentIterable.from(classNames).transformAndConcat(new Function<String, Iterable<T>>(){

            @Nullable
            public Iterable<T> apply(@Nullable String input) {
                return currentBuild.createExtensions(input);
            }
        }).toList();
    }

    private static <T> T getWithDefault(String annotationName, String propName, T def, Annotable target, Annotable ... others) {
        T b = Annotations.evaluate(annotationName, propName, target, others);
        if (b == null) {
            return def;
        }
        return b;
    }

    private static <T> T evaluate(String annotationName, String parameterName, Annotable mandatory, Annotable ... others) {
        Object retval = null;
        ArrayList<Annotable> targets = new ArrayList<Annotable>();
        targets.add(mandatory);
        targets.addAll(Arrays.asList(others));
        for (Annotable target : targets) {
            Object o;
            AnnotationRef annotationRef = Annotations.findRef(target, annotationName);
            if (annotationRef == null || (o = Annotations.findProperty(annotationRef, parameterName)) == null) continue;
            retval = o;
        }
        return (T)retval;
    }

    private static Object findProperty(AnnotationRef annotationRef, String propName) {
        for (TypeInstanceProperty typeInstanceProperty : annotationRef.structuredValue().properties()) {
            if (!typeInstanceProperty.name().equalsIgnoreCase(propName)) continue;
            if (typeInstanceProperty.isArray().booleanValue()) {
                return Annotations.toValueList(typeInstanceProperty.values());
            }
            return typeInstanceProperty.value().value();
        }
        return null;
    }

    private static List<Object> toValueList(List<TypeInstance> values) {
        return Lists.transform(values, (Function)new Function<TypeInstance, Object>(){

            @Nullable
            public Object apply(@Nullable TypeInstance input) {
                return input.value();
            }
        });
    }

    private static AnnotationRef findRef(Annotable annotable, String annotation) {
        for (AnnotationRef annotationRef : annotable.annotations()) {
            if (!annotationRef.annotation().name().equalsIgnoreCase(annotation)) continue;
            return annotationRef;
        }
        return null;
    }

    public abstract T getWithContext(CurrentBuild var1, Annotable var2, Annotable ... var3);

    public T getValueWithDefault(T def, Annotable annotable, Annotable ... others) {
        T t = this.getWithContext(null, annotable, others);
        if (t == null) {
            return def;
        }
        return t;
    }

    public T get(V10GType type) {
        return this.getWithContext(null, (Annotable)type.implementation(), new Annotable[0]);
    }

    public T get(V10GResource resource) {
        return this.getWithContext(null, (Annotable)resource.implementation(), new Annotable[0]);
    }

    public T get(V10GMethod method) {
        return this.getWithContext(null, (Annotable)method.implementation(), new Annotable[0]);
    }

    public T get(V10GResponse response) {
        return this.getWithContext(null, (Annotable)response.implementation(), new Annotable[0]);
    }

    public T get(T def, V10GType type) {
        return this.get(def, (Annotable)type.implementation());
    }

    public T get(T def, Annotable type) {
        return this.getValueWithDefault(def, type, new Annotable[0]);
    }

    public T get(Annotable type) {
        return this.getValueWithDefault(null, type, new Annotable[0]);
    }

    public T get(T def, Annotable type, Annotable others) {
        return this.getValueWithDefault(def, type, others);
    }
}

