/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GFinder;
import org.raml.jaxrs.generator.GFinderListener;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.v10.TypeUtils;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class V10Finder
implements GFinder {
    private final Api api;
    private final V10TypeRegistry registry;
    private Map<String, TypeDeclaration> foundTypes = new HashMap<String, TypeDeclaration>();

    public V10Finder(Api api, V10TypeRegistry registry) {
        this.api = api;
        this.registry = registry;
    }

    @Override
    public GFinder findTypes(GFinderListener listener) {
        if (this.api.uses() != null) {
            this.goThroughLibraries(new HashSet<String>(), this.api.uses(), listener);
        }
        this.localTypes(this.api.types(), listener);
        this.resourceTypes(this.api.resources(), listener);
        return this;
    }

    private void resourceTypes(List<Resource> resources, GFinderListener listener) {
        for (Resource resource : resources) {
            this.resourceTypes(resource.resources(), listener);
            for (TypeDeclaration parameterTypeDeclaration : resource.uriParameters()) {
                V10GType type = this.registry.fetchType(parameterTypeDeclaration.type(), parameterTypeDeclaration);
                listener.newTypeDeclaration(type);
            }
            for (Method method : resource.methods()) {
                this.typesInBodies(resource, method, method.body(), listener);
            }
        }
    }

    private void typesInBodies(Resource resource, Method method, List<TypeDeclaration> body, GFinderListener listener) {
        V10GType type;
        for (TypeDeclaration typeDeclaration : body) {
            TypeDeclaration supertype = this.pullSupertype(typeDeclaration);
            if (supertype == null || !TypeUtils.shouldCreateNewClass(typeDeclaration, supertype)) continue;
            V10GType type2 = this.registry.fetchType(resource, method, typeDeclaration);
            listener.newTypeDeclaration(type2);
        }
        for (TypeDeclaration parameterTypeDeclaration : method.queryParameters()) {
            type = this.registry.fetchType(resource, method, parameterTypeDeclaration);
            listener.newTypeDeclaration(type);
        }
        for (TypeDeclaration headerType : method.headers()) {
            type = this.registry.fetchType(resource, method, headerType);
            listener.newTypeDeclaration(type);
        }
        for (Response response : method.responses()) {
            for (TypeDeclaration typeDeclaration : response.body()) {
                TypeDeclaration supertype = this.pullSupertype(typeDeclaration);
                if (supertype == null || !TypeUtils.shouldCreateNewClass(typeDeclaration, supertype)) continue;
                V10GType type3 = this.registry.fetchType(resource, method, response, typeDeclaration);
                listener.newTypeDeclaration(type3);
            }
        }
    }

    private TypeDeclaration pullSupertype(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof StringTypeDeclaration && typeDeclaration.type() != null && typeDeclaration.type().equals("string") && ((StringTypeDeclaration)typeDeclaration).enumValues().size() > 0) {
            return (TypeDeclaration)typeDeclaration.parentTypes().get(0);
        }
        return this.foundTypes.get(typeDeclaration.type());
    }

    private void localTypes(List<TypeDeclaration> types, GFinderListener listener) {
        for (TypeDeclaration typeDeclaration : types) {
            this.foundTypes.put(typeDeclaration.name(), typeDeclaration);
            V10GType type = this.registry.fetchType(typeDeclaration);
            listener.newTypeDeclaration(type);
        }
    }

    private void goThroughLibraries(Set<String> visitedLibraries, List<Library> libraries, GFinderListener listener) {
        for (Library library : libraries) {
            if (visitedLibraries.contains(library.name())) continue;
            visitedLibraries.add(library.name());
            this.goThroughLibraries(visitedLibraries, library.uses(), listener);
            for (TypeDeclaration typeDeclaration : library.types()) {
                V10GType type = this.registry.fetchType(typeDeclaration);
                listener.newTypeDeclaration(type);
            }
        }
    }

    @Override
    public void setupConstruction(CurrentBuild currentBuild) {
        List<V10GType> schemaTypes = this.registry.fetchSchemaTypes();
        for (V10GType schemaType : schemaTypes) {
            try {
                Files.write((CharSequence)schemaType.schema(), (File)new File(currentBuild.getSchemaRepository(), schemaType.name()), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new GenerationException("while writing schemas", e);
            }
        }
    }
}

