/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.typegenerators;

import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.extensions.types.TypeContextImpl;
import org.raml.jaxrs.generator.extension.types.TypeExtension;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;

public class SimpleTypeGenerator
implements JavaPoetTypeGenerator {
    private final V10GType originalType;
    private final V10TypeRegistry registry;
    private final CurrentBuild currentBuild;
    private final TypeExtension typeExtension;

    public SimpleTypeGenerator(V10GType originalType, V10TypeRegistry registry, CurrentBuild currentBuild, TypeExtension typeExtension) {
        this.originalType = originalType;
        this.registry = registry;
        this.currentBuild = currentBuild;
        this.typeExtension = typeExtension;
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory, BuildPhase buildPhase) throws IOException {
        rootDirectory.into(this.typeExtension.onType(new SimpleTypeContextImpl(this.currentBuild, this), null, this.originalType, buildPhase));
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.originalType.defaultJavaTypeName(this.currentBuild.getModelPackage());
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
        this.output(rootDirectory, (BuildPhase)null);
    }

    private static class SimpleTypeContextImpl
    extends TypeContextImpl {
        private final SimpleTypeGenerator objectType;

        public SimpleTypeContextImpl(CurrentBuild build, SimpleTypeGenerator objectType) {
            super(build);
            this.objectType = objectType;
        }

        @Override
        public void addImplementation() {
            this.getBuild().newImplementation(this.objectType);
        }

        @Override
        public void createInternalClass(JavaPoetTypeGenerator internalGenerator) {
            this.getBuild().internalClass(this.objectType, internalGenerator);
        }
    }
}

