/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.typegenerators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.extensions.types.TypeContextImpl;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.jaxrs.generator.v10.typegenerators.SimpleUnionExtension;
import org.raml.jaxrs.generator.v10.types.V10GTypeUnion;

public class UnionTypeGenerator
implements JavaPoetTypeGenerator {
    private final V10TypeRegistry registry;
    private final V10GType v10GType;
    private final ClassName javaName;
    private final CurrentBuild currentBuild;

    public UnionTypeGenerator(V10TypeRegistry registry, V10GType v10GType, ClassName javaName, CurrentBuild currentBuild) {
        this.registry = registry;
        this.v10GType = v10GType;
        this.javaName = javaName;
        this.currentBuild = currentBuild;
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
        SimpleUnionExtension ux = new SimpleUnionExtension(this.javaName, this.registry);
        rootDirectory.into(ux.onUnionType(new UnionTypeContextImpl(this.currentBuild, this), null, (V10GTypeUnion)this.v10GType, BuildPhase.INTERFACE));
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory, BuildPhase buildPhase) throws IOException {
        this.output(rootDirectory);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.javaName;
    }

    private static class UnionTypeContextImpl
    extends TypeContextImpl {
        private final UnionTypeGenerator objectType;

        public UnionTypeContextImpl(CurrentBuild build, UnionTypeGenerator objectType) {
            super(build);
            this.objectType = objectType;
        }

        @Override
        public void addImplementation() {
            this.getBuild().newImplementation(this.objectType);
        }

        @Override
        public void createInternalClass(JavaPoetTypeGenerator internalGenerator) {
            this.getBuild().internalClass(this.objectType, internalGenerator);
        }
    }
}

