/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.types;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.CreationModel;
import org.raml.jaxrs.generator.v10.V10GProperty;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.jaxrs.generator.v10.types.V10GTypeArray;
import org.raml.jaxrs.generator.v10.types.V10GTypeEnum;
import org.raml.jaxrs.generator.v10.types.V10GTypeJson;
import org.raml.jaxrs.generator.v10.types.V10GTypeObject;
import org.raml.jaxrs.generator.v10.types.V10GTypeScalar;
import org.raml.jaxrs.generator.v10.types.V10GTypeUnion;
import org.raml.jaxrs.generator.v10.types.V10GTypeXml;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class V10GTypeFactory {
    public static V10GType createResponseBodyType(V10TypeRegistry registry, Resource resource, Method method, Response response, TypeDeclaration typeDeclaration) {
        return new V10GTypeObject(registry, typeDeclaration, Names.ramlTypeName(resource, method, response, typeDeclaration), Annotations.CLASS_NAME.get(Names.javaTypeName(resource, method, response, typeDeclaration), (Annotable)typeDeclaration), true, V10GTypeFactory.getProperties(typeDeclaration, registry), V10GTypeFactory.getParents(typeDeclaration, registry), null);
    }

    public static V10GType createExplicitlyNamedType(V10TypeRegistry registry, String s, TypeDeclaration typeDeclaration) {
        return new V10GTypeObject(registry, typeDeclaration, s, Annotations.CLASS_NAME.get(Names.typeName(typeDeclaration.name()), (Annotable)typeDeclaration), false, V10GTypeFactory.getProperties(typeDeclaration, registry), V10GTypeFactory.getParents(typeDeclaration, registry), null);
    }

    public static V10GType createInlineType(V10TypeRegistry registry, String ramlName, String javaClassName, TypeDeclaration typeDeclaration, V10GType containingType) {
        return new V10GTypeObject(registry, typeDeclaration, ramlName, Annotations.CLASS_NAME.get(javaClassName, (Annotable)typeDeclaration), true, V10GTypeFactory.getProperties(typeDeclaration, registry), V10GTypeFactory.getParents(typeDeclaration, registry), containingType);
    }

    public static V10GType createScalar(String name, TypeDeclaration typeDeclaration) {
        return new V10GTypeScalar(name, typeDeclaration);
    }

    public static V10GType createArray(V10TypeRegistry registry, String name, ArrayTypeDeclaration typeDeclaration, CreationModel model) {
        return new V10GTypeArray(registry, name, typeDeclaration, model);
    }

    public static V10GType createEnum(V10TypeRegistry v10TypeRegistry, String name, StringTypeDeclaration typeDeclaration, CreationModel model) {
        return new V10GTypeEnum(v10TypeRegistry, name, Annotations.CLASS_NAME.get(Names.typeName(typeDeclaration.name()), (Annotable)typeDeclaration), typeDeclaration, model);
    }

    public static V10GType createEnum(V10TypeRegistry v10TypeRegistry, String name, String javaTypeName, StringTypeDeclaration typeDeclaration, CreationModel model) {
        return new V10GTypeEnum(v10TypeRegistry, name, javaTypeName, typeDeclaration, model);
    }

    public static V10GType createJson(JSONTypeDeclaration jsonTypeDeclaration, String ramlName, CreationModel model) {
        return new V10GTypeJson(jsonTypeDeclaration, ramlName, Annotations.CLASS_NAME.get(Names.typeName(ramlName), (Annotable)jsonTypeDeclaration), model);
    }

    public static V10GType createJson(JSONTypeDeclaration jsonTypeDeclaration, String ramlName, String javaTypeName, CreationModel model) {
        return new V10GTypeJson(jsonTypeDeclaration, ramlName, javaTypeName, model);
    }

    public static V10GType createXml(XMLTypeDeclaration typeDeclaration, String ramlName, CreationModel model) {
        return new V10GTypeXml(typeDeclaration, ramlName, Annotations.CLASS_NAME.get(Names.typeName(ramlName), (Annotable)typeDeclaration), model);
    }

    public static V10GType createXml(XMLTypeDeclaration typeDeclaration, String ramlName, String javaName, CreationModel model) {
        return new V10GTypeXml(typeDeclaration, ramlName, javaName, model);
    }

    public static V10GType createUnion(V10TypeRegistry registry, UnionTypeDeclaration typeDeclaration, String ramlName, CreationModel model) {
        return new V10GTypeUnion(registry, typeDeclaration, ramlName, Annotations.CLASS_NAME.get(Names.typeName(ramlName), (Annotable)typeDeclaration), model);
    }

    public static V10GType createUnion(V10TypeRegistry registry, UnionTypeDeclaration typeDeclaration, String ramlName, String javaName, CreationModel model) {
        return new V10GTypeUnion(registry, typeDeclaration, ramlName, javaName, model);
    }

    private static List<V10GType> getParents(TypeDeclaration typeDeclaration, final V10TypeRegistry registry) {
        return Lists.transform((List)typeDeclaration.parentTypes(), (Function)new Function<TypeDeclaration, V10GType>(){

            @Nullable
            public V10GType apply(@Nullable TypeDeclaration input) {
                return registry.fetchType(input);
            }
        });
    }

    private static List<V10GProperty> getProperties(TypeDeclaration input, final V10TypeRegistry registry) {
        if (input instanceof ObjectTypeDeclaration) {
            ObjectTypeDeclaration otd = (ObjectTypeDeclaration)input;
            return Lists.transform((List)otd.properties(), (Function)new Function<TypeDeclaration, V10GProperty>(){

                @Nullable
                public V10GProperty apply(@Nullable TypeDeclaration declaration) {
                    return new V10GProperty(declaration, registry.fetchType(declaration.type(), declaration));
                }
            });
        }
        return Collections.emptyList();
    }
}

