/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.io.Files;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.builders.AbstractTypeGenerator;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.CodeModelTypeGenerator;
import org.raml.jaxrs.generator.ramltypes.GType;

public class JsonSchemaTypeGenerator
extends AbstractTypeGenerator<JCodeModel>
implements CodeModelTypeGenerator {
    private final CurrentBuild build;
    private final String pack;
    private final GType type;
    private final ClassName name;
    private final String schema;

    public JsonSchemaTypeGenerator(CurrentBuild build, String pack, GType type, ClassName name, String schema) {
        this.build = build;
        this.pack = pack;
        this.type = type;
        this.name = name;
        this.schema = schema;
    }

    @Override
    public void output(CodeContainer<JCodeModel> container, BuildPhase buildPhase) throws IOException {
        GenerationConfig config = this.build.getJsonMapperConfig();
        SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, (Annotator)new Jackson2Annotator(), new SchemaStore()), new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        File schemaFile = File.createTempFile("schema", "json", this.build.getSchemaRepository());
        Files.write((CharSequence)this.schema, (File)schemaFile, (Charset)Charset.defaultCharset());
        try {
            mapper.generate(codeModel, this.name.simpleName(), this.pack, schemaFile.toURL());
        }
        catch (IOException e) {
            throw new GenerationException(e);
        }
        container.into(codeModel);
    }

    public GType getType() {
        return this.type;
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return ClassName.get((String)this.name.packageName(), (String)(this.build.getJsonMapperConfig().getClassNamePrefix() + this.name.simpleName() + this.build.getJsonMapperConfig().getClassNameSuffix()), (String[])new String[0]);
    }
}

