/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.raml.jaxrs.generator.extension.resources.api.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceContext;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JerseyMultipartFormDataResourceExtension
implements GlobalResourceExtension {
    @Override
    public TypeSpec.Builder onResource(ResourceContext context, GResource resource, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GMethod method, GRequest gRequest, MethodSpec.Builder methodSpec) {
        if (gRequest != null && "multipart/form-data".equals(gRequest.mediaType())) {
            MethodSpec old = methodSpec.build();
            MethodSpec.Builder newMethod = MethodSpec.methodBuilder((String)old.name).returns(old.returnType);
            this.addExistingParameters(old, newMethod);
            for (AnnotationSpec annotation : old.annotations) {
                newMethod.addAnnotation(annotation);
            }
            for (TypeName exception : old.exceptions) {
                newMethod.addException(exception);
            }
            newMethod.addJavadoc("$L", new Object[]{old.javadoc});
            newMethod.addModifiers((Iterable)old.modifiers);
            ObjectTypeDeclaration declaration = (ObjectTypeDeclaration)gRequest.type().implementation();
            for (TypeDeclaration property : declaration.properties()) {
                if (property instanceof FileTypeDeclaration) {
                    newMethod.addParameter(ParameterSpec.builder((TypeName)ClassName.get(InputStream.class), (String)(property.name() + "Stream"), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"org.glassfish.jersey.media.multipart.FormDataParam")).addMember("value", "$S", new Object[]{property.name()}).build()).build());
                    newMethod.addParameter(ParameterSpec.builder((TypeName)ClassName.bestGuess((String)"org.glassfish.jersey.media.multipart.FormDataContentDisposition"), (String)(property.name() + "Disposition"), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"org.glassfish.jersey.media.multipart.FormDataParam")).addMember("value", "$S", new Object[]{property.name()}).build()).build());
                    continue;
                }
                TypeName typeName = context.fetchRamlToPojoBuilder().fetchType(property.type(), property);
                methodSpec.addParameter(ParameterSpec.builder((TypeName)typeName, (String)property.name(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"org.glassfish.jersey.media.multipart.FormDataParam")).addMember("value", "$S", new Object[]{property.name()}).build()).build());
            }
            return newMethod;
        }
        return methodSpec;
    }

    private void addExistingParameters(MethodSpec old, MethodSpec.Builder newMethod) {
        for (ParameterSpec parameter : old.parameters) {
            if (FluentIterable.from((Iterable)parameter.annotations).filter((Predicate)new Predicate<AnnotationSpec>(){

                public boolean apply(@Nullable AnnotationSpec annotationSpec) {
                    return annotationSpec.type.equals((Object)ClassName.get(PathParam.class)) || annotationSpec.type.equals((Object)ClassName.get(QueryParam.class));
                }
            }).size() <= 0) continue;
            newMethod.addParameter(parameter);
        }
    }

    @Override
    public TypeSpec.Builder onResponseClass(ResourceContext context, GMethod method, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GResponse responseMethod, MethodSpec.Builder methodSpec) {
        return methodSpec;
    }
}

