/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.apache.commons.io.FileUtils;
import org.jsonschema2pojo.GenerationConfig;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.GFinder;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.GeneratorType;
import org.raml.jaxrs.generator.JsonSchemaTypeGenerator;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.ResponseSupport;
import org.raml.jaxrs.generator.TypeFindingListener;
import org.raml.jaxrs.generator.XmlSchemaTypeGenerator;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.CodeModelTypeGenerator;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.RamlToPojoTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.builders.resources.ResourceGenerator;
import org.raml.jaxrs.generator.extension.resources.api.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceClassExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceMethodExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResponseClassExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResponseMethodExtension;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.ExtensionManager;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.types.V10RamlToPojoGType;
import org.raml.ramltopojo.PluginDef;
import org.raml.ramltopojo.RamlToPojo;
import org.raml.ramltopojo.RamlToPojoBuilder;
import org.raml.ramltopojo.ResultingPojos;
import org.raml.ramltopojo.TypeFetchers;
import org.raml.ramltopojo.plugin.PluginManager;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class CurrentBuild {
    private final Api api;
    private ExtensionManager extensionManager;
    private final List<ResourceGenerator> resources = new ArrayList<ResourceGenerator>();
    private final Map<String, TypeGenerator> builtTypes = new ConcurrentHashMap<String, TypeGenerator>();
    private final PluginManager pluginManager = PluginManager.createPluginManager((String)"META-INF/ramltojaxrs-plugin.properties");
    private GlobalResourceExtension.Composite resourceExtensionList = new GlobalResourceExtension.Composite();
    private Map<String, GeneratorType> foundTypes = new HashMap<String, GeneratorType>();
    private final List<JavaPoetTypeGenerator> supportGenerators = new ArrayList<JavaPoetTypeGenerator>();
    private Configuration configuration;
    private Set<JavaPoetTypeGenerator> implementations = new HashSet<JavaPoetTypeGenerator>();
    private ArrayListMultimap<JavaPoetTypeGenerator, JavaPoetTypeGenerator> internalTypesPerClass = ArrayListMultimap.create();
    private File schemaRepository;
    private RamlToPojo ramlToPojo;

    public CurrentBuild(Api api, ExtensionManager extensionManager) {
        this.api = api;
        this.extensionManager = extensionManager;
        this.configuration = Configuration.defaultConfiguration();
    }

    public RamlToPojo fetchRamlToPojoBuilder() {
        if (this.ramlToPojo == null) {
            this.ramlToPojo = RamlToPojoBuilder.builder((Api)this.api).inPackage(this.getModelPackage()).fetchTypes(TypeFetchers.fromAnywhere()).build((List)FluentIterable.from(this.typeConfiguration()).transform((Function)new Function<String, String>(){

                @Nullable
                public String apply(@Nullable String s) {
                    if (s.contains(".")) {
                        return s;
                    }
                    return "core." + s;
                }
            }).toList());
        }
        return this.ramlToPojo;
    }

    public File getSchemaRepository() {
        if (this.schemaRepository == null) {
            this.schemaRepository = Files.createTempDir();
        }
        return this.schemaRepository;
    }

    public Api getApi() {
        return this.api;
    }

    public String getResourcePackage() {
        return this.configuration.getResourcePackage();
    }

    public String getModelPackage() {
        return this.configuration.getModelPackage();
    }

    public String getSupportPackage() {
        return this.configuration.getSupportPackage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(final File rootDirectory) throws IOException {
        try {
            if (this.resources.size() > 0) {
                ResponseSupport.buildSupportClasses(rootDirectory, this.getSupportPackage());
            }
            for (TypeGenerator typeGenerator : this.builtTypes.values()) {
                if (typeGenerator instanceof RamlToPojoTypeGenerator) {
                    RamlToPojoTypeGenerator ramlToPojoTypeGenerator = (RamlToPojoTypeGenerator)typeGenerator;
                    ramlToPojoTypeGenerator.output(new CodeContainer<ResultingPojos>(){

                        @Override
                        public void into(ResultingPojos g) throws IOException {
                            g.createFoundTypes(rootDirectory.getAbsolutePath());
                        }
                    });
                }
                if (typeGenerator instanceof JavaPoetTypeGenerator) {
                    this.buildTypeTree(rootDirectory, (JavaPoetTypeGenerator)typeGenerator);
                    continue;
                }
                if (!(typeGenerator instanceof CodeModelTypeGenerator)) continue;
                CodeModelTypeGenerator b = (CodeModelTypeGenerator)typeGenerator;
                b.output(new CodeContainer<JCodeModel>(){

                    @Override
                    public void into(JCodeModel g) throws IOException {
                        g.build(rootDirectory);
                    }
                });
            }
            for (ResourceGenerator resourceGenerator : this.resources) {
                resourceGenerator.output(new CodeContainer<TypeSpec>(){

                    @Override
                    public void into(TypeSpec g) throws IOException {
                        JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getResourcePackage(), (TypeSpec)g).skipJavaLangImports(true);
                        file.build().writeTo(rootDirectory);
                    }
                });
            }
            for (JavaPoetTypeGenerator javaPoetTypeGenerator : this.supportGenerators) {
                javaPoetTypeGenerator.output(new CodeContainer<TypeSpec.Builder>(){

                    @Override
                    public void into(TypeSpec.Builder g) throws IOException {
                        JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getSupportPackage(), (TypeSpec)g.build()).skipJavaLangImports(true);
                        file.build().writeTo(rootDirectory);
                    }
                });
            }
        }
        finally {
            if (this.schemaRepository != null) {
                FileUtils.deleteDirectory((File)this.schemaRepository);
            }
        }
    }

    private void buildTypeTree(final File rootDirectory, final JavaPoetTypeGenerator typeGenerator) throws IOException {
        JavaPoetTypeGenerator b = typeGenerator;
        b.output(new CodeContainer<TypeSpec.Builder>(){

            @Override
            public void into(final TypeSpec.Builder containing) throws IOException {
                for (JavaPoetTypeGenerator generator : CurrentBuild.this.internalTypesPerClass.get((Object)typeGenerator)) {
                    generator.output(new CodeContainer<TypeSpec.Builder>(){

                        @Override
                        public void into(TypeSpec.Builder g) throws IOException {
                            g.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
                            containing.addType(g.build());
                        }
                    }, BuildPhase.INTERFACE);
                }
                if (containing != null) {
                    JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getModelPackage(), (TypeSpec)containing.build()).skipJavaLangImports(true);
                    file.build().writeTo(rootDirectory);
                }
            }
        }, BuildPhase.INTERFACE);
        if (this.implementations.contains(b)) {
            b.output(new CodeContainer<TypeSpec.Builder>(){

                @Override
                public void into(final TypeSpec.Builder containing) throws IOException {
                    for (JavaPoetTypeGenerator generator : CurrentBuild.this.internalTypesPerClass.get((Object)typeGenerator)) {
                        generator.output(new CodeContainer<TypeSpec.Builder>(){

                            @Override
                            public void into(TypeSpec.Builder g) throws IOException {
                                g.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
                                containing.addType(g.build());
                            }
                        }, BuildPhase.IMPLEMENTATION);
                    }
                    if (containing != null) {
                        JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getModelPackage(), (TypeSpec)containing.build()).skipJavaLangImports(true);
                        file.build().writeTo(rootDirectory);
                    }
                }
            }, BuildPhase.IMPLEMENTATION);
        }
    }

    public void newGenerator(String ramlTypeName, TypeGenerator generator) {
        this.builtTypes.put(ramlTypeName, generator);
    }

    public void newSupportGenerator(JavaPoetTypeGenerator generator) {
        this.supportGenerators.add(generator);
    }

    public void newResource(ResourceGenerator rg) {
        this.resources.add(rg);
    }

    public void constructClasses(GFinder finder) {
        TypeFindingListener listener = new TypeFindingListener(this.foundTypes);
        finder.findTypes(listener);
        finder.setupConstruction(this);
        for (GeneratorType type : this.foundTypes.values()) {
            type.construct(this);
        }
    }

    public List<String> typeConfiguration() {
        return Arrays.asList(this.configuration.getTypeConfiguration());
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public GenerationConfig getJsonMapperConfig() {
        return this.configuration.createJsonSchemaGenerationConfig();
    }

    private <T> void loadBasePlugins(Set<T> plugins, Class<T> pluginType) {
        ImmutableList configuredPlugins = FluentIterable.from(this.typeConfiguration()).transform((Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String s) {
                return "ramltojaxrs." + s;
            }
        }).toList();
        for (String basePlugin : configuredPlugins) {
            plugins.addAll(this.pluginManager.getClassesForName(basePlugin, Collections.emptyList(), pluginType));
        }
    }

    public ResourceClassExtension<GResource> pluginsForResourceClass(Function<Collection<ResourceClassExtension<GResource>>, ResourceClassExtension<GResource>> provider, GResource resource) {
        List<PluginDef> data = Annotations.RESOURCE_PLUGINS.get(Collections.emptyList(), this.api, resource);
        Set<ResourceClassExtension> plugins = this.buildPluginList(ResourceClassExtension.class, data);
        return (ResourceClassExtension)provider.apply((Object)FluentIterable.from(plugins).transform((Function)new Function<ResourceClassExtension, ResourceClassExtension<GResource>>(){

            @Nullable
            public ResourceClassExtension<GResource> apply(@Nullable ResourceClassExtension resourceClassExtension) {
                return resourceClassExtension;
            }
        }).toList());
    }

    public ResponseClassExtension<GMethod> pluginsForResponseClass(Function<Collection<ResponseClassExtension<GMethod>>, ResponseClassExtension<GMethod>> provider, GMethod method) {
        List<PluginDef> data = Annotations.RESPONSE_CLASS_PLUGINS.get(Collections.emptyList(), this.api, method);
        Set<ResponseClassExtension> plugins = this.buildPluginList(ResponseClassExtension.class, data);
        return (ResponseClassExtension)provider.apply((Object)FluentIterable.from(plugins).transform((Function)new Function<ResponseClassExtension, ResponseClassExtension<GMethod>>(){

            @Nullable
            public ResponseClassExtension<GMethod> apply(@Nullable ResponseClassExtension resourceClassExtension) {
                return resourceClassExtension;
            }
        }).toList());
    }

    public ResourceMethodExtension<GMethod> pluginsForResourceMethod(Function<Collection<ResourceMethodExtension<GMethod>>, ResourceMethodExtension<GMethod>> provider, GMethod resource) {
        List<PluginDef> data = Annotations.METHOD_PLUGINS.get(Collections.emptyList(), this.api, resource);
        Set<ResourceMethodExtension> plugins = this.buildPluginList(ResourceMethodExtension.class, data);
        return (ResourceMethodExtension)provider.apply((Object)FluentIterable.from(plugins).transform((Function)new Function<ResourceMethodExtension, ResourceMethodExtension<GMethod>>(){

            @Nullable
            public ResourceMethodExtension<GMethod> apply(@Nullable ResourceMethodExtension resourceClassExtension) {
                return resourceClassExtension;
            }
        }).toList());
    }

    public ResponseMethodExtension<GResponse> pluginsForResponseMethod(Function<Collection<ResponseMethodExtension<GResponse>>, ResponseMethodExtension<GResponse>> provider, GResponse resource) {
        List<PluginDef> data = Annotations.RESPONSE_PLUGINS.get(Collections.emptyList(), this.api, resource);
        Set<ResponseMethodExtension> plugins = this.buildPluginList(ResponseMethodExtension.class, data);
        return (ResponseMethodExtension)provider.apply((Object)FluentIterable.from(plugins).transform((Function)new Function<ResponseMethodExtension, ResponseMethodExtension<GResponse>>(){

            @Nullable
            public ResponseMethodExtension<GResponse> apply(@Nullable ResponseMethodExtension resourceClassExtension) {
                return resourceClassExtension;
            }
        }).toList());
    }

    private <T> Set<T> buildPluginList(Class<T> cls, List<PluginDef> data) {
        LinkedHashSet plugins = new LinkedHashSet();
        this.loadBasePlugins(plugins, cls);
        for (PluginDef datum : data) {
            plugins.addAll(this.pluginManager.getClassesForName(datum.getPluginName(), datum.getArguments(), cls));
        }
        return plugins;
    }

    public <T> Iterable<T> createExtensions(String className) {
        try {
            Class<?> c = Class.forName(className);
            return Collections.singletonList(c.newInstance());
        }
        catch (ClassNotFoundException e) {
            return FluentIterable.from(this.extensionManager.getClassesForName(className)).transform(new Function<Class, T>(){

                @Nullable
                public T apply(@Nullable Class input) {
                    try {
                        return input.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e1) {
                        throw new GenerationException(e1);
                    }
                }
            });
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new GenerationException(e);
        }
    }

    public GlobalResourceExtension withResourceListeners() {
        return this.resourceExtensionList;
    }

    public V10GType fetchType(Resource implementation, Method method, TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof JSONTypeDeclaration) {
            return (V10GType)((JsonSchemaTypeGenerator)this.builtTypes.get(typeDeclaration.type())).getType();
        }
        if (typeDeclaration instanceof XMLTypeDeclaration) {
            return (V10GType)((XmlSchemaTypeGenerator)this.builtTypes.get(typeDeclaration.type())).getType();
        }
        RamlToPojo ramlToPojo = this.fetchRamlToPojoBuilder();
        if (ramlToPojo.isInline(typeDeclaration)) {
            TypeName typeName = ramlToPojo.fetchType(Names.javaTypeName(implementation, method, typeDeclaration), typeDeclaration);
            V10RamlToPojoGType type = new V10RamlToPojoGType(Names.javaTypeName(implementation, method, typeDeclaration), typeDeclaration);
            type.setJavaType(typeName);
            return type;
        }
        TypeName typeName = ramlToPojo.fetchType(typeDeclaration.type(), typeDeclaration);
        V10RamlToPojoGType type = new V10RamlToPojoGType(typeDeclaration.type(), typeDeclaration);
        type.setJavaType(typeName);
        return type;
    }

    public V10GType fetchType(Resource resource, TypeDeclaration input) {
        RamlToPojo ramlToPojo = this.fetchRamlToPojoBuilder();
        if (ramlToPojo.isInline(input)) {
            TypeName typeName = this.fetchRamlToPojoBuilder().fetchType(Names.javaTypeName(resource, input), input);
            V10RamlToPojoGType type = new V10RamlToPojoGType(input);
            type.setJavaType(typeName);
            return type;
        }
        TypeName typeName = this.fetchRamlToPojoBuilder().fetchType(input.type(), input);
        V10RamlToPojoGType type = new V10RamlToPojoGType(input);
        type.setJavaType(typeName);
        return type;
    }

    public V10GType fetchType(Resource resource, Method method, Response response, TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof JSONTypeDeclaration) {
            return (V10GType)((JsonSchemaTypeGenerator)this.builtTypes.get(typeDeclaration.type())).getType();
        }
        if (typeDeclaration instanceof XMLTypeDeclaration) {
            return (V10GType)((XmlSchemaTypeGenerator)this.builtTypes.get(typeDeclaration.type())).getType();
        }
        RamlToPojo ramlToPojo = this.fetchRamlToPojoBuilder();
        if (ramlToPojo.isInline(typeDeclaration)) {
            TypeName typeName = this.fetchRamlToPojoBuilder().fetchType(Names.javaTypeName(resource, method, response, typeDeclaration), typeDeclaration);
            V10RamlToPojoGType type = new V10RamlToPojoGType(Names.javaTypeName(resource, method, response, typeDeclaration), typeDeclaration);
            type.setJavaType(typeName);
            return type;
        }
        TypeName typeName = this.fetchRamlToPojoBuilder().fetchType(typeDeclaration.type(), typeDeclaration);
        V10RamlToPojoGType type = new V10RamlToPojoGType(typeDeclaration.type(), typeDeclaration);
        type.setJavaType(typeName);
        return type;
    }

    public V10GType fetchType(String name, TypeDeclaration typeDeclaration) {
        TypeName typeName = this.fetchRamlToPojoBuilder().fetchType(name, typeDeclaration);
        V10RamlToPojoGType type = new V10RamlToPojoGType(typeDeclaration);
        type.setJavaType(typeName);
        return type;
    }
}

