/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GObjectType;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.ramltypes.GType;

public class ResourceUtils {
    private static final Pattern PARAM = Pattern.compile(".*?\\{([^}]+?)\\}");

    public static void fillInBodiesAndResponses(GResource resource, Multimap<GMethod, GRequest> incomingBodies, Multimap<GMethod, GResponse> responses) {
        for (GMethod method : resource.methods()) {
            if (method.body().size() == 0) {
                incomingBodies.put((Object)method, null);
            } else {
                for (GRequest typeDeclaration : method.body()) {
                    incomingBodies.put((Object)method, (Object)typeDeclaration);
                }
            }
            if (method.responses().size() == 0) {
                incomingBodies.put((Object)method, null);
                continue;
            }
            for (GResponse response : method.responses()) {
                responses.put((Object)method, (Object)response);
            }
        }
    }

    public static List<GParameter> accumulateUriParameters(GResource resource) {
        ImmutableSet<String> seenHere = ResourceUtils.extractSeen(new HashSet<String>(), resource);
        ArrayList<GParameter> parameters = new ArrayList<GParameter>();
        parameters.addAll(Lists.reverse((List)FluentIterable.from(resource.uriParameters()).append(ResourceUtils.allMatches(seenHere, resource.relativePath())).toList()));
        while (resource.parentResource() != null) {
            resource = resource.parentResource();
            seenHere = ResourceUtils.extractSeen(seenHere, resource);
            parameters.addAll(Lists.reverse((List)FluentIterable.from(resource.uriParameters()).append(ResourceUtils.allMatches(seenHere, resource.relativePath())).toList()));
        }
        Collections.reverse(parameters);
        return parameters;
    }

    private static ImmutableSet<String> extractSeen(Set<String> seen, GResource resource) {
        return FluentIterable.from(resource.uriParameters()).transform((Function)new Function<GParameter, String>(){

            @Nullable
            public String apply(@Nullable GParameter gParameter) {
                return gParameter.name();
            }
        }).append(seen).toSet();
    }

    private static List<GParameter> allMatches(Set<String> seenHere, String path) {
        ArrayList<GParameter> allMatches = new ArrayList<GParameter>();
        if (path == null) {
            return allMatches;
        }
        Matcher m = PARAM.matcher(path);
        while (m.find()) {
            String group = m.group(1);
            if (seenHere.contains(group)) continue;
            allMatches.add(new ImplicitStringGParameter(group));
        }
        return allMatches;
    }

    private static class ImplicitStringGParameter
    implements GParameter {
        private final String group;

        public ImplicitStringGParameter(String group) {
            this.group = group;
        }

        @Override
        public String defaultValue() {
            return null;
        }

        @Override
        public String name() {
            return this.group;
        }

        @Override
        public GType type() {
            return new GType(){

                @Override
                public String type() {
                    return "string";
                }

                @Override
                public String name() {
                    return "string";
                }

                @Override
                public TypeName defaultJavaTypeName(String pack) {
                    return ClassName.get(String.class);
                }

                @Override
                public boolean isJson() {
                    return false;
                }

                @Override
                public boolean isXml() {
                    return false;
                }

                @Override
                public boolean isArray() {
                    return false;
                }

                @Override
                public boolean isEnum() {
                    return false;
                }

                @Override
                public boolean isScalar() {
                    return true;
                }

                @Override
                public String schema() {
                    return null;
                }

                @Override
                public GType arrayContents() {
                    return null;
                }

                @Override
                public void construct(CurrentBuild currentBuild, GObjectType objectType) {
                }

                @Override
                public void setJavaType(TypeName generatedJavaType) {
                }

                @Override
                public Object implementation() {
                    return null;
                }
            };
        }

        @Override
        public Object implementation() {
            return null;
        }
    }
}

