/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v08;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GAbstractionFactory;
import org.raml.jaxrs.generator.GFinder;
import org.raml.jaxrs.generator.GFinderListener;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.v08.V08GType;
import org.raml.jaxrs.generator.v08.V08TypeRegistry;
import org.raml.v2.api.model.v08.api.Api;
import org.raml.v2.api.model.v08.api.GlobalSchema;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.bodies.Response;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.resources.Resource;

public class V08Finder
implements GFinder {
    private final Api api;
    private final GAbstractionFactory factory;
    private final V08TypeRegistry registry;
    private Map<String, String> globalSchemas = new HashMap<String, String>();

    public V08Finder(Api api, GAbstractionFactory factory, V08TypeRegistry registry) {
        this.api = api;
        this.factory = factory;
        this.registry = registry;
    }

    @Override
    public GFinder findTypes(GFinderListener listener) {
        this.goThroughSchemas(this.api.schemas());
        this.resourceTypes(this.api.resources(), listener);
        return this;
    }

    @Override
    public void setupConstruction(CurrentBuild currentBuild) {
        for (String name : this.globalSchemas.keySet()) {
            try {
                Files.write((CharSequence)this.globalSchemas.get(name), (File)new File(currentBuild.getSchemaRepository(), name), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new GenerationException("while writing schemas", e);
            }
        }
    }

    private void goThroughSchemas(List<GlobalSchema> schemas) {
        for (GlobalSchema schema : schemas) {
            this.globalSchemas.put(schema.key(), schema.value().value());
        }
    }

    private void resourceTypes(List<Resource> resources, GFinderListener listener) {
        for (Resource resource : resources) {
            this.resourceTypes(resource.resources(), listener);
            for (Method method : resource.methods()) {
                this.typesInBodies(resource, method, method.body(), listener);
            }
        }
    }

    private void typesInBodies(Resource resource, Method method, List<BodyLike> body, GFinderListener listener) {
        for (BodyLike typeDeclaration : body) {
            V08GType type;
            if (typeDeclaration.schema() == null) continue;
            if (this.globalSchemas.containsKey(typeDeclaration.schema().value())) {
                type = new V08GType(typeDeclaration.schema().value(), typeDeclaration);
                this.registry.addType(type);
                listener.newTypeDeclaration(type);
                continue;
            }
            type = new V08GType(resource, method, typeDeclaration);
            this.registry.addType(type);
            listener.newTypeDeclaration(type);
        }
        for (Response response : method.responses()) {
            for (BodyLike typeDeclaration : response.body()) {
                V08GType type;
                if (typeDeclaration.schema() == null) continue;
                if (this.globalSchemas.containsKey(typeDeclaration.schema().value())) {
                    type = new V08GType(typeDeclaration.schema().value(), typeDeclaration);
                    this.registry.addType(type);
                    listener.newTypeDeclaration(type);
                    continue;
                }
                type = new V08GType(resource, method, response, typeDeclaration);
                this.registry.addType(type);
                listener.newTypeDeclaration(type);
            }
        }
    }

    public Map<String, String> globalSchemas() {
        return this.globalSchemas;
    }
}

