/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GFinder;
import org.raml.jaxrs.generator.GFinderListener;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.v10.CreationModel;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.types.V10GTypeFactory;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class V10Finder
implements GFinder {
    private final CurrentBuild build;
    private final Api api;
    private Map<String, V10GType> foundTypes = new HashMap<String, V10GType>();

    public V10Finder(CurrentBuild build, Api api) {
        this.build = build;
        this.api = api;
    }

    @Override
    public GFinder findTypes(GFinderListener listener) {
        if (this.api.uses() != null) {
            this.goThroughLibraries(new HashSet<String>(), this.api.uses(), listener);
        }
        this.localTypes(this.api.types(), listener);
        this.resourceTypes(this.api.resources(), listener);
        return this;
    }

    private void resourceTypes(List<Resource> resources, GFinderListener listener) {
        for (Resource resource : resources) {
            this.resourceTypes(resource.resources(), listener);
            for (TypeDeclaration parameterTypeDeclaration : resource.uriParameters()) {
                if (!this.isInline(parameterTypeDeclaration)) continue;
                V10GType type = this.createInlineFromResourcesAndSuch(Names.ramlTypeName(resource, parameterTypeDeclaration), Names.javaTypeName(resource, parameterTypeDeclaration), parameterTypeDeclaration);
                listener.newTypeDeclaration(type);
            }
            for (Method method : resource.methods()) {
                this.typesInBodies(resource, method, method.body(), listener);
            }
        }
    }

    private void typesInBodies(Resource resource, Method method, List<TypeDeclaration> body, GFinderListener listener) {
        V10GType type;
        for (TypeDeclaration typeDeclaration : body) {
            if (!this.isInline(typeDeclaration)) continue;
            if ("application/x-www-form-urlencoded".equals(typeDeclaration.name())) {
                ObjectTypeDeclaration formParameters = (ObjectTypeDeclaration)typeDeclaration;
                for (TypeDeclaration formParameter : formParameters.properties()) {
                    V10GType type2 = this.createInlineFromResourcesAndSuch(Names.ramlTypeName(resource, method, formParameter), Names.javaTypeName(resource, method, formParameter), formParameter);
                    listener.newTypeDeclaration(type2);
                }
                continue;
            }
            type = this.createInlineFromResourcesAndSuch(Names.ramlTypeName(resource, method, typeDeclaration), Names.javaTypeName(resource, method, typeDeclaration), typeDeclaration);
            listener.newTypeDeclaration(type);
        }
        for (TypeDeclaration parameterTypeDeclaration : method.queryParameters()) {
            if (!this.isInline(parameterTypeDeclaration)) continue;
            type = this.createInlineFromResourcesAndSuch(Names.ramlTypeName(resource, method, parameterTypeDeclaration), Names.javaTypeName(resource, method, parameterTypeDeclaration), parameterTypeDeclaration);
            listener.newTypeDeclaration(type);
        }
        for (TypeDeclaration headerType : method.headers()) {
            if (!this.isInline(headerType)) continue;
            type = this.createInlineFromResourcesAndSuch(Names.ramlTypeName(resource, method, headerType), Names.javaTypeName(resource, method, headerType), headerType);
            listener.newTypeDeclaration(type);
        }
        for (Response response : method.responses()) {
            for (TypeDeclaration typeDeclaration : response.body()) {
                if (!this.isInline(typeDeclaration)) continue;
                V10GType type3 = this.createInlineFromResourcesAndSuch(Names.ramlTypeName(resource, method, response, typeDeclaration), Names.javaTypeName(resource, method, response, typeDeclaration), typeDeclaration);
                listener.newTypeDeclaration(type3);
            }
        }
    }

    private void localTypes(List<TypeDeclaration> types, GFinderListener listener) {
        for (TypeDeclaration typeDeclaration : types) {
            V10GType type = this.createTypeFromLibraryPart(typeDeclaration);
            listener.newTypeDeclaration(type);
        }
    }

    private V10GType putInFoundTypes(String name, V10GType type) {
        this.foundTypes.put(name, type);
        return type;
    }

    private V10GType createTypeFromLibraryPart(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof JSONTypeDeclaration) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createJson((JSONTypeDeclaration)typeDeclaration, typeDeclaration.name(), CreationModel.INLINE_FROM_TYPE));
        }
        if (typeDeclaration instanceof XMLTypeDeclaration) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createXml((XMLTypeDeclaration)typeDeclaration, typeDeclaration.name(), CreationModel.INLINE_FROM_TYPE));
        }
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createInlineType(typeDeclaration.name(), typeDeclaration));
        }
        if (typeDeclaration instanceof UnionTypeDeclaration) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createUnion(typeDeclaration.name(), (UnionTypeDeclaration)typeDeclaration));
        }
        if (typeDeclaration instanceof StringTypeDeclaration && !((StringTypeDeclaration)typeDeclaration).enumValues().isEmpty()) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createEnum(typeDeclaration.name(), (StringTypeDeclaration)typeDeclaration));
        }
        if (typeDeclaration instanceof NumberTypeDeclaration && !((NumberTypeDeclaration)typeDeclaration).enumValues().isEmpty()) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createEnum(typeDeclaration.name(), (NumberTypeDeclaration)typeDeclaration));
        }
        if (typeDeclaration instanceof ArrayTypeDeclaration) {
            return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createArray(typeDeclaration.name(), (ArrayTypeDeclaration)typeDeclaration));
        }
        return this.putInFoundTypes(typeDeclaration.name(), V10GTypeFactory.createScalar(typeDeclaration.name(), typeDeclaration));
    }

    private boolean isInline(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof JSONTypeDeclaration || typeDeclaration instanceof XMLTypeDeclaration) {
            return !this.foundTypes.containsKey(typeDeclaration.type());
        }
        if (typeDeclaration instanceof ObjectTypeDeclaration || typeDeclaration instanceof UnionTypeDeclaration || typeDeclaration instanceof StringTypeDeclaration && !((StringTypeDeclaration)typeDeclaration).enumValues().isEmpty() || typeDeclaration instanceof NumberTypeDeclaration && !((NumberTypeDeclaration)typeDeclaration).enumValues().isEmpty()) {
            return this.build.fetchRamlToPojoBuilder().isInline(typeDeclaration);
        }
        return false;
    }

    private V10GType createInlineFromResourcesAndSuch(String ramlName, String suggestedJavaName, TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof JSONTypeDeclaration) {
            return this.putInFoundTypes(ramlName, V10GTypeFactory.createJson((JSONTypeDeclaration)typeDeclaration, ramlName, suggestedJavaName, CreationModel.INLINE_FROM_TYPE));
        }
        if (typeDeclaration instanceof XMLTypeDeclaration) {
            return this.putInFoundTypes(ramlName, V10GTypeFactory.createXml((XMLTypeDeclaration)typeDeclaration, ramlName, suggestedJavaName, CreationModel.INLINE_FROM_TYPE));
        }
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            return this.putInFoundTypes(ramlName, V10GTypeFactory.createInlineType(suggestedJavaName, typeDeclaration));
        }
        if (typeDeclaration instanceof UnionTypeDeclaration) {
            return this.putInFoundTypes(ramlName, V10GTypeFactory.createUnion(suggestedJavaName, (UnionTypeDeclaration)typeDeclaration));
        }
        if (typeDeclaration instanceof StringTypeDeclaration && !((StringTypeDeclaration)typeDeclaration).enumValues().isEmpty()) {
            return this.putInFoundTypes(ramlName, V10GTypeFactory.createEnum(suggestedJavaName, (StringTypeDeclaration)typeDeclaration));
        }
        if (typeDeclaration instanceof ArrayTypeDeclaration) {
            return this.putInFoundTypes(ramlName, V10GTypeFactory.createArray(ramlName, (ArrayTypeDeclaration)typeDeclaration));
        }
        return this.putInFoundTypes(ramlName, V10GTypeFactory.createScalar(ramlName, typeDeclaration));
    }

    private void goThroughLibraries(Set<String> visitedLibraries, List<Library> libraries, GFinderListener listener) {
        for (Library library : libraries) {
            if (visitedLibraries.contains(library.name())) continue;
            visitedLibraries.add(library.name());
            this.goThroughLibraries(visitedLibraries, library.uses(), listener);
            for (TypeDeclaration typeDeclaration : library.types()) {
                V10GType type = this.createTypeFromLibraryPart(typeDeclaration);
                listener.newTypeDeclaration(type);
            }
        }
    }

    @Override
    public void setupConstruction(CurrentBuild currentBuild) {
        ImmutableList schemaTypes = FluentIterable.from(this.foundTypes.values()).filter((Predicate)new Predicate<V10GType>(){

            public boolean apply(@Nullable V10GType input) {
                return input.isJson() || input.isXml();
            }
        }).toList();
        for (V10GType schemaType : schemaTypes) {
            try {
                Files.write((CharSequence)schemaType.schema(), (File)new File(currentBuild.getSchemaRepository(), schemaType.name()), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new GenerationException("while writing schemas", e);
            }
        }
    }
}

