/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension.resources;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.extension.resources.api.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceContext;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v10.V10GMethod;
import org.raml.ramltopojo.extensions.jsr303.AnnotationAdder;
import org.raml.ramltopojo.extensions.jsr303.FacetValidation;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class Jsr303ResourceExtension
implements GlobalResourceExtension {
    @Override
    public TypeSpec.Builder onResource(ResourceContext context, GResource resource, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GMethod method, GRequest gRequest, MethodSpec.Builder methodSpec) {
        MethodSpec spec = methodSpec.build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)spec.name);
        builder.addAnnotations((Iterable)spec.annotations);
        if (spec.code != null) {
            builder.addCode(spec.code);
        }
        if (spec.defaultValue != null) {
            builder.defaultValue(spec.defaultValue);
        }
        builder.addExceptions((Iterable)spec.exceptions);
        if (spec.javadoc != null) {
            builder.addJavadoc("$L", new Object[]{spec.javadoc});
        }
        builder.addModifiers((Iterable)spec.modifiers);
        for (ParameterSpec parameter : spec.parameters) {
            final ParameterSpec.Builder parameterBuilder = parameter.toBuilder();
            Optional<GParameter> declaration = this.getTypeDeclarationForName((V10GMethod)method, parameter.name);
            if (declaration.isPresent()) {
                FacetValidation.addAnnotations((TypeDeclaration)((TypeDeclaration)((GParameter)declaration.get()).implementation()), (AnnotationAdder)new AnnotationAdder(){

                    public TypeName typeName() {
                        return parameterBuilder.build().type;
                    }

                    public void addAnnotation(AnnotationSpec spec) {
                        parameterBuilder.addAnnotation(spec);
                    }
                });
                builder.addParameter(parameterBuilder.build());
                continue;
            }
            builder.addParameter(parameter);
        }
        if (spec.returnType != null) {
            builder.returns(spec.returnType);
        }
        builder.addTypeVariables((Iterable)spec.typeVariables);
        builder.varargs(spec.varargs);
        return builder;
    }

    Optional<GParameter> getTypeDeclarationForName(V10GMethod request, final String name) {
        return FluentIterable.from(request.queryParameters()).firstMatch((Predicate)new Predicate<GParameter>(){

            public boolean apply(@Nullable GParameter gParameter) {
                return gParameter.name().equals(name);
            }
        });
    }

    @Override
    public TypeSpec.Builder onResponseClass(ResourceContext context, GMethod method, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GResponse responseMethod, MethodSpec.Builder methodSpec) {
        return methodSpec;
    }
}

