/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GObjectType;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class GeneratorType {
    private final GObjectType objectType;
    private final GType declaredType;

    public static GeneratorType generatorFrom(GType typeDeclaration) {
        if (typeDeclaration.isJson()) {
            return new GeneratorType(GObjectType.JSON_OBJECT_TYPE, typeDeclaration);
        }
        if (typeDeclaration.implementation() instanceof UnionTypeDeclaration) {
            return new GeneratorType(GObjectType.UNION_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isXml()) {
            return new GeneratorType(GObjectType.XML_OBJECT_TYPE, typeDeclaration);
        }
        if (typeDeclaration.implementation() instanceof ObjectTypeDeclaration) {
            return new GeneratorType(GObjectType.PLAIN_OBJECT_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isEnum()) {
            return new GeneratorType(GObjectType.ENUMERATION_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isArray()) {
            return new GeneratorType(GObjectType.PLAIN_OBJECT_TYPE, typeDeclaration);
        }
        return new GeneratorType(GObjectType.SCALAR, typeDeclaration);
    }

    public GeneratorType(GObjectType objectType, GType declaredType) {
        this.objectType = objectType;
        this.declaredType = declaredType;
    }

    public GObjectType getObjectType() {
        return this.objectType;
    }

    public void construct(CurrentBuild currentBuild) {
        if (this.getObjectType() != GObjectType.SCALAR) {
            this.declaredType.construct(currentBuild, this.objectType);
        }
    }
}

