/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.source;

import com.google.common.base.Splitter;
import java.nio.file.Path;
import java.nio.file.Paths;

class Utilities {
    Utilities() {
    }

    public static Path getSourceFileRelativePath(Class<?> declaringClass) {
        Path packageRelativePath = Utilities.transformIntoPath(declaringClass);
        String declaringFileName = Utilities.getSourceFileName(declaringClass);
        return packageRelativePath.resolve(declaringFileName);
    }

    private static String getSourceFileName(Class<?> declaringClass) {
        String SOURCE_FILE_EXTENSION = ".java";
        return declaringClass.getSimpleName() + ".java";
    }

    private static Path transformIntoPath(Class<?> clazz) {
        Splitter splitter = Splitter.on((char)'.').omitEmptyStrings();
        Iterable subPackages = splitter.split((CharSequence)clazz.getPackage().getName());
        Path current = Paths.get("", new String[0]);
        for (String subPackage : subPackages) {
            current = current.resolve(subPackage);
        }
        return current;
    }
}

