/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.raml.jaxrs.model.HttpVerb;
import org.raml.jaxrs.model.JaxRsEntity;
import org.raml.jaxrs.model.JaxRsFormParameter;
import org.raml.jaxrs.model.JaxRsHeaderParameter;
import org.raml.jaxrs.model.JaxRsMethod;
import org.raml.jaxrs.model.JaxRsMultiPartFormDataParameter;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.parser.model.Utilities;
import org.raml.jaxrs.parser.source.SourceParser;

class JerseyJaxRsMethod
implements JaxRsMethod {
    private final ResourceMethod resourceMethod;
    private final SourceParser sourceParser;

    private JerseyJaxRsMethod(ResourceMethod resourceMethod, SourceParser sourceParser) {
        this.resourceMethod = resourceMethod;
        this.sourceParser = sourceParser;
    }

    public static JerseyJaxRsMethod create(ResourceMethod resourceMethod, SourceParser sourceParser) {
        Preconditions.checkNotNull((Object)resourceMethod);
        Preconditions.checkNotNull((Object)sourceParser);
        return new JerseyJaxRsMethod(resourceMethod, sourceParser);
    }

    public HttpVerb getHttpVerb() {
        return HttpVerb.fromStringUnchecked((String)this.resourceMethod.getHttpMethod());
    }

    public List<MediaType> getConsumedMediaTypes() {
        return this.resourceMethod.getConsumedTypes();
    }

    public List<MediaType> getProducedMediaTypes() {
        return this.resourceMethod.getProducedTypes();
    }

    public List<JaxRsQueryParameter> getQueryParameters() {
        return Utilities.toJaxRsQueryParameters(Utilities.getQueryParameters(this.resourceMethod), this.sourceParser).toList();
    }

    public List<JaxRsHeaderParameter> getHeaderParameters() {
        return Utilities.toJaxRsHeaderParameters(Utilities.getHeaderParameters(this.resourceMethod), this.sourceParser).toList();
    }

    public List<JaxRsFormParameter> getFormParameters() {
        return Utilities.toJaxRsFormParameters(Utilities.getFormParameters(this.resourceMethod)).toList();
    }

    public List<JaxRsMultiPartFormDataParameter> getMultiPartFormDataParameters() {
        return Utilities.toJaxRsMultiPartFormDataParameter(Utilities.getMultiPartFormDataParameter(this.resourceMethod), this.sourceParser).toList();
    }

    public Optional<JaxRsEntity> getConsumedEntity() {
        return Utilities.toJaxRsEntityParameters(Utilities.getConsumedParameter(this.resourceMethod), this.sourceParser);
    }

    public Optional<JaxRsEntity> getProducedEntity() {
        return Utilities.getReturnValue(this.resourceMethod, this.sourceParser);
    }

    public Optional<String> getDescription() {
        return this.sourceParser.getDocumentationFor(this.resourceMethod.getInvocable().getDefinitionMethod());
    }

    public <T extends Annotation> Optional<T> getJavaAnnotation(Class<T> annotationType) {
        return Optional.fromNullable(this.resourceMethod.getInvocable().getHandlingMethod().getAnnotation(annotationType));
    }
}

