/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.raml.jaxrs.model.JaxRsApplication;
import org.raml.jaxrs.model.JaxRsResource;
import org.raml.jaxrs.model.JaxRsSupportedAnnotation;
import org.raml.jaxrs.parser.model.JerseyJaxRsResource;
import org.raml.jaxrs.parser.source.SourceParser;

public class JerseyJaxRsApplication
implements JaxRsApplication {
    private final Set<JaxRsResource> resources;
    private final Set<JaxRsSupportedAnnotation> supportedAnnotations;
    private final String topPackage;

    private JerseyJaxRsApplication(Set<JaxRsResource> resources, Set<JaxRsSupportedAnnotation> supportedAnnotations, String topPackage) {
        this.resources = resources;
        this.supportedAnnotations = supportedAnnotations;
        this.topPackage = topPackage;
    }

    private static JerseyJaxRsApplication create(Iterable<JaxRsResource> resources, Set<JaxRsSupportedAnnotation> supportedAnnotations, String topPackage) {
        Preconditions.checkNotNull(resources);
        return new JerseyJaxRsApplication((Set<JaxRsResource>)ImmutableSet.copyOf(resources), supportedAnnotations, topPackage);
    }

    public static JerseyJaxRsApplication fromRuntimeResources(Iterable<RuntimeResource> runtimeResources, final SourceParser sourceParser, Set<JaxRsSupportedAnnotation> supportedAnnotations, String topPackage) {
        return JerseyJaxRsApplication.create((Iterable<JaxRsResource>)FluentIterable.from(runtimeResources).transform((Function)new Function<RuntimeResource, JaxRsResource>(){

            @Nullable
            public JaxRsResource apply(@Nullable RuntimeResource runtimeResource) {
                return JerseyJaxRsResource.create(runtimeResource, sourceParser);
            }
        }), supportedAnnotations, topPackage);
    }

    public Set<JaxRsResource> getResources() {
        return this.resources;
    }

    public Set<JaxRsSupportedAnnotation> getSupportedAnnotations() {
        return this.supportedAnnotations;
    }

    public String getTopPackage() {
        return this.topPackage;
    }
}

