/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.gatherers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.glassfish.jersey.server.ResourceConfig;
import org.raml.jaxrs.parser.gatherers.JaxRsClassesGatherer;
import org.raml.utilities.builder.NonNullableField;
import org.raml.utilities.builder.Preconditions;

public class JerseyGatherer
implements JaxRsClassesGatherer {
    private final ResourceConfig resourceConfig;

    @VisibleForTesting
    JerseyGatherer(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    private static JerseyGatherer create(ResourceConfig resourceConfig) {
        com.google.common.base.Preconditions.checkNotNull((Object)resourceConfig);
        return new JerseyGatherer(resourceConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Set<Class<?>> jaxRsClasses() {
        return this.resourceConfig.getClasses();
    }

    @VisibleForTesting
    ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public static class Builder {
        private NonNullableField<List<Path>> applications = NonNullableField.unset();
        private NonNullableField<ClassLoader> classLoader = NonNullableField.unset();

        private Builder() {
        }

        public Builder forApplications(Path first, Path ... theRest) {
            Preconditions.checkUnset(this.applications, (String)"applications");
            ImmutableList paths = ImmutableList.builder().add((Object)first).add((Object[])theRest).build();
            this.applications = NonNullableField.of((Object)paths);
            return this;
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            Preconditions.checkUnset(this.classLoader, (String)"class loader");
            this.classLoader = NonNullableField.of((Object)classLoader);
            return this;
        }

        public JerseyGatherer build() {
            Preconditions.checkSet(this.applications, (String)"applications");
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfig.files(true, (String[])FluentIterable.from((Iterable)((Iterable)this.applications.get())).transform((Function)new Function<Path, String>(){

                @Nullable
                public String apply(@Nullable Path path) {
                    return path.toString();
                }
            }).toArray(String.class));
            if (this.classLoader.isSet()) {
                resourceConfig.setClassLoader((ClassLoader)this.classLoader.get());
            }
            return JerseyGatherer.create(resourceConfig);
        }
    }
}

