/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.annotation.Nullable;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.raml.jaxrs.model.JaxRsMethod;
import org.raml.jaxrs.model.JaxRsResource;
import org.raml.jaxrs.model.Path;
import org.raml.jaxrs.parser.model.JerseyJaxRsMethod;
import org.raml.jaxrs.parser.model.JerseyJaxRsPath;
import org.raml.jaxrs.parser.source.SourceParser;

class JerseyJaxRsResource
implements JaxRsResource {
    private final RuntimeResource runtimeResource;
    private final SourceParser sourceParser;

    private JerseyJaxRsResource(RuntimeResource runtimeResource, SourceParser sourceParser) {
        this.runtimeResource = runtimeResource;
        this.sourceParser = sourceParser;
    }

    public static JaxRsResource create(RuntimeResource runtimeResource, SourceParser sourceParser) {
        Preconditions.checkNotNull((Object)runtimeResource);
        Preconditions.checkNotNull((Object)sourceParser);
        return new JerseyJaxRsResource(runtimeResource, sourceParser);
    }

    public Path getPath() {
        return JerseyJaxRsPath.fromRuntimeResource(this.runtimeResource);
    }

    public List<JaxRsMethod> getMethods() {
        return FluentIterable.from((Iterable)this.runtimeResource.getResourceMethods()).transform((Function)new Function<ResourceMethod, JaxRsMethod>(){

            @Nullable
            public JaxRsMethod apply(@Nullable ResourceMethod resourceMethod) {
                return JerseyJaxRsResource.ourMethodOf(resourceMethod, JerseyJaxRsResource.this.sourceParser);
            }
        }).toList();
    }

    public List<JaxRsResource> getChildren() {
        return FluentIterable.from((Iterable)this.runtimeResource.getChildRuntimeResources()).transform((Function)new Function<RuntimeResource, JaxRsResource>(){

            @Nullable
            public JaxRsResource apply(@Nullable RuntimeResource runtimeResource) {
                return JerseyJaxRsResource.create(runtimeResource, JerseyJaxRsResource.this.sourceParser);
            }
        }).toList();
    }

    private static JaxRsMethod ourMethodOf(ResourceMethod resourceMethod, SourceParser sourceParser) {
        return JerseyJaxRsMethod.create(resourceMethod, sourceParser);
    }
}

