/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.cli;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.raml.jaxrs.converter.RamlConfiguration;
import org.raml.jaxrs.raml.core.DefaultRamlConfiguration;
import org.raml.jaxrs.raml.core.OneStopShop;

public class Main {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(Option.builder((String)"a").required().longOpt("applicationDirectory").hasArg().desc("application path").build());
        options.addOption(Option.builder((String)"o").required().longOpt("output").hasArg().desc("RAML output file").build());
        options.addOption("s", "sourceRoot", true, "JaxRs source root");
        options.addOption("t", "translatedAnnotations", true, "translated annotation list (comma separated");
        options.addOption("p", "topPackage", true, "top package used for resources");
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine command = parser.parse(options, args);
            Path jaxRsResourceFile = Paths.get(command.getOptionValue('a'), new String[0]);
            Path ramlOutputFile = Paths.get(command.getOptionValue('o'), new String[0]);
            Path jaxRsSourceRoot = null;
            if (command.hasOption('s')) {
                jaxRsSourceRoot = Paths.get(command.getOptionValue('s'), new String[0]);
            }
            String topPackage = null;
            if (command.hasOption('p')) {
                topPackage = command.getOptionValue('p');
            }
            DefaultRamlConfiguration ramlConfiguration = DefaultRamlConfiguration.forApplication((String)jaxRsResourceFile.getFileName().toString(), Collections.emptySet(), (String)topPackage);
            OneStopShop.Builder builder = OneStopShop.builder().withJaxRsClassesRoot(jaxRsResourceFile).withRamlOutputFile(ramlOutputFile).withRamlConfiguration((RamlConfiguration)ramlConfiguration);
            if (null != jaxRsSourceRoot) {
                builder.withSourceCodeRoot(jaxRsSourceRoot);
            }
            if (command.hasOption('t')) {
                Object[] classes = command.getOptionValue('t').split(",");
                ImmutableList c = FluentIterable.of((Object[])classes).transform((Function)new Function<String, Class<? extends Annotation>>(){

                    @Nullable
                    public Class<? extends Annotation> apply(@Nullable String input) {
                        try {
                            return Class.forName(input);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("while building translated annotations list", e);
                        }
                    }
                }).toList();
                builder.withTranslatedAnnotations((List)c);
            }
            OneStopShop oneStopShop = builder.build();
            oneStopShop.parseJaxRsAndOutputRaml();
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            System.err.println(e.getMessage());
            formatter.printHelp("jaxrstoraml", options, true);
        }
    }
}

